// Enum.cbp
#include <iostream>
#include <cstdlib>
#include <ctime>

using namespace std;

enum CardSuits
{
   Club,
   Diamond,
   Heart,
   Spade
};

enum CardElements
{
   Ace,
   Two,
   Three,
   Four,
   Five,
   Six,
   Seven,
   Eight,
   Nine,
   Ten,
   Jack,
   Queen,
   King
};

string GetSuitString(CardSuits suit)
{
   string s;
   switch(suit)
   {
      case Club:
         s = "trefl";
         break;
      case Diamond:
         s = "karo";
         break;
      case Heart:
         s = "kier";
         break;
      case Spade:
         s = "pik";
         break;
   }

   return s;
}

string GetElementString(CardElements element)
{
   string e;

   switch(element)
   {
      case Ace:
         e = "as";
         break;
      case Two:
         e = "dwa";
         break;
      case Three:
         e = "trzy";
         break;
      case Four:
         e = "cztery";
         break;
      case Five:
         e = "pi";
         break;
      case Six:
         e = "sze";
         break;
      case Seven:
         e = "siedem";
         break;
      case Eight:
         e = "osiem";
         break;
      case Nine:
         e = "dziewi";
         break;
      case Ten:
         e = "dziesi";
         break;
      case Jack:
         e = "walet";
         break;
      case Queen:
         e = "dama";
         break;
      case King:
         e = "krl";
         break;
   }

   return e;
}

int GenerateRandomNumber(int min, int max)
{
   // Uywa zmiennej statycznej ze wzgldu na wydajno,
   // tak aby obliczy t warto tylko jednokrotnie.
   static const double fraction =
      1.0 / (static_cast<double>(RAND_MAX) + 1.0);

   // Rwno rozkada losowe liczby
   // w wybranym zakresie.
   return min + static_cast<int>(
      (max - min + 1) * (rand() * fraction));
}

int main()
{
   setlocale( LC_ALL, "" );
   
   // Okrela wstpny seed (ziarno) na podstawie zegara systemowego.
   srand(static_cast<unsigned int>(time(0)));

   // Generuje losowy kolor i kart.
   int iSuit = GenerateRandomNumber(0, 3);
   int iElement = GenerateRandomNumber(0, 12);

   CardSuits suit = static_cast<CardSuits>(iSuit);
   CardElements element = static_cast<CardElements>(iElement);

   cout << "Twoja karta to ";
   cout << GetElementString(element);
   cout << " koloru " << GetSuitString(suit) << endl;

   return 0;
}
