// Projekt: Binary_Search_Tree.cbp
// Plik   : AVL_Tree.cpp

#include <iostream>
#include "AVLNode.h"

using namespace std;

int main()
{
    cout << "AVL Tree" << endl;

    // Instancjonuje AVL.
    AVL * avlTree = new AVL;

    // Wstawia pierwszy klucz.
    avlTree->Insert(69);

    /*
        Dodaje klucz 62.
              69
             /
           62
    */
    avlTree->Insert(62);

    /*
        Dodaje klucz 46 i obraca w prawo, bo balance = 2.
              62
             /  \
           46    69
    */
    avlTree->Insert(46);

    /*
        Dodaje klucz 32.
              62
             /  \
           46    69
          /
        32
    */
    avlTree->Insert(32);

    /*
        Dodaje klucz 24 i obraca w prawo, bo balance = 2.
              62
             /  \
           32    69
          /  \
        24    46
    */
    avlTree->Insert(24);

    /*
        Dodaje klucz 13 i obraca w prawo, bo balance = 2.
              32
             /  \
           24    62
          /     /  \
        13    46    69
    */
    avlTree->Insert(13);

    // Test avlTree
    // Successor(32) powinno zwrci 46
    // Successor(13) powinno zwrci 24
    // Successor(69) powinno zwrci -1 lub NULL
    cout << "Successor(32) = ";
    cout << avlTree->Successor(24) << endl;
    cout << "Successor(13) = ";
    cout << avlTree->Successor(13) << endl;
    cout << "Successor(69) = ";
    cout << avlTree->Successor(69) << endl;

    return 0;
}
