// Projekt: Quick_Sort.cbp
// Plik: Quick_Sort.cpp

#include <iostream>

using namespace std;

int Partition(
   int arr[],
   int startIndex,
   int endIndex)
{
   // Wskazuje pierwszy element jako element podziaowy.
   int pivot = arr[startIndex];

   // Podlisty po lewej i po prawej
   // s pocztkowo puste.
   int middleIndex = startIndex;

   // Iteruje po arr[1 ... n - 1].
   for (int i = startIndex + 1; i <= endIndex; ++i)
   {
      if (arr[i] < pivot)
      {
         // Biecy element znajduje si w podlicie po lewej.
         // Przygotowuje miejsce poprzez przestawienie indeksu rodkowego.
         ++middleIndex;

         // arr[middleIndex] jest elementem podlisty o prawej.
         // Zamienia go z biecym elementem,
         // ktry znajduje si w podlicie po lewej.
         swap(arr[i], arr[middleIndex]);
      }
   }

   // Teraz element arr[middleIndex]
   // znajduje si w podlicie po lewej.
   // Moemy go zamieni z elementem podziaowym,
   // tak aby element podziaowy znalaz si na waciwej pozycji,
   // czyli pomidzy podlist po lewej, a podlist po prawej.
   swap(arr[startIndex], arr[middleIndex]);

   // Zwraca indeks elementu podziaowego,
   // ktry zostanie uyty przy kolejnym sortowaniu.
   return middleIndex;
}

void QuickSort(
   int arr[],
   int startIndex,
   int endIndex)
{
   // Wykonuje proces sortowania tylko wtedy,
   // kiedy indeks kocowy jest wikszy od pocztkowego.
   if (startIndex < endIndex)
   {
      // Zwraca pooenie elementu podziaowego z funkcji Partition().
      // pivotIndex jest indeksem elementu, ktry
      // ju znajduje si we waciwym miejscu.
      int pivotIndex = Partition(arr, startIndex, endIndex);

      // Sortuje podlist po lewej
      // arr[startIndex ... pivotIndex - 1]
      QuickSort(arr, startIndex, pivotIndex - 1);

      // Sortuje podlist po prawej
      // arr[pivotIndex + 1 ... endIndex]
      QuickSort(arr, pivotIndex + 1, endIndex);
   }
}

int main()
{
   setlocale( LC_ALL, "" );
   
   cout << "Sortowanie szybkie" << endl;

   // Inicjalizuje now tablic.
   int arr[] = {25, 21, 12, 40, 37, 43, 14, 28};
   int arrSize = sizeof(arr)/sizeof(*arr);

   // Wywietla tablic wejciow.
   cout << "Tablica wejciowa: ";
   for (int i=0; i < arrSize; ++i)
      cout << arr[i] << " ";
   cout << endl;

   // Sortuje tablic algorytmem QuickSort.
   QuickSort(arr, 0, arrSize - 1);

   // Wywietla posortowan tablic.
   cout << "Posortowana tablica: ";
   for (int i=0; i < arrSize; ++i)
      cout << arr[i] << " ";
   cout << endl;

   return 0;
}
