// Projekt: Hash_Table_OP_LP.cbp
// Plik   : HashTable.cpp

#include "HashTable.h"

using namespace std;

HashTable::HashTable()
{
    // Inicjalizuje currentSize o wartoci 0.
    currentSize = 0;

    // Inicjalizuje tablic.
    arr = new HashElement * [TABLE_SIZE];
    for(int i = 0 ; i < TABLE_SIZE ; ++i)
        arr[i] = NULL;

    // Okrela zawarto usunitego wza.
    deletedElement = new HashElement(-1, "");
}

int HashTable::HashFunction(int key)
{
    return key % TABLE_SIZE;
}

void HashTable::Insert(int key, string value)
{
    // Niemoliwe jest zapisanie nowego elementu, jeli w tablicy mieszajcej brakuje wolnego miejsca.
    if (currentSize >= TABLE_SIZE)
        return;

    // Tworzy tymczasowy element do wstawienia do tablicy mieszajcej.
    HashElement * temp =
        new HashElement(key, value);

    // Pozyskuje klucz mieszajcy z funkcji mieszajcej.
    int hashIndex = HashFunction(key);

    // Znajduje kolejne wolne miejsce, uywajc szukania liniowego.
    while(arr[hashIndex] != NULL &&
        arr[hashIndex]->Key != key &&
        arr[hashIndex]->Key != -1)
    {
        ++hashIndex;
        hashIndex %= TABLE_SIZE;
    }

    // Jeli wstawiony ma by nowy element, zwiksza warto currentSize.
    if(arr[hashIndex] == NULL ||
        arr[hashIndex]->Key == -1)
    {
        ++currentSize;
        arr[hashIndex] = temp;
    }
}

string HashTable::Search(int key)
{
    // Pozyskuje klucz mieszajcy z funkcji mieszajcej.
    int hashIndex = HashFunction(key);

    // Wyszukuje element o podanym kluczu.
    while(arr[hashIndex] != NULL &&
        arr[hashIndex]->Key != deletedElement->Key)
    {
        // Jeli element znaleziono, zwraca jego warto.
        if(arr[hashIndex]->Key == key)
            return arr[hashIndex]->Value;

        // Dalej szuka klucza, uywajc szukania liniowego.
        ++hashIndex;
        hashIndex %= TABLE_SIZE;
    }

    // Jeli nie znaleziono klucza, zwraca null.
    return "";
}

void HashTable::Remove(int key)
{
    // Pozyskuje klucz mieszajcy z funkcji mieszajcej.
    int hashIndex = HashFunction(key);

    // Wyszukuje element o podanym kluczu.
    while(arr[hashIndex] != NULL)
    {
        // Jeli element znaleziono, komrka zostaje oznaczona jako deletedElement.
        if(arr[hashIndex]->Key == key)
        {
            arr[hashIndex] = deletedElement;

            // Zmniejsza tablic.
            --currentSize;

            // Nie ma potrzeby szukania dalej.
            return;
        }

        // Dalej szuka klucza, uywajc szukania liniowego.
        ++hashIndex;
        hashIndex %= TABLE_SIZE;
    }

    // Uwaga: nic si nie dzieje, jeli klucz nie zosta znaleziony.
}

bool HashTable::IsEmpty()
{
    return currentSize == 0;
}

void HashTable::PrintHashTable()
{
    // Iteruje po tablicy.
    for(int i = 0 ; i < currentSize; ++i)
    {
        // Wywietla element, jeeli istnieje.
        if(arr[i] != NULL && arr[i]->Key != -1)
        {
            cout << "Komrka: " << i;
            cout << " Klucz: " << arr[i]->Key;
            cout << " Warto: " << arr[i]->Value;
            cout << std::endl;
        }
    }
}
