// Project: Radix_Sort.cbp
// File   : Queue.h
#ifndef QUEUE_H
#define QUEUE_H

#include "Node.h"

template <typename T>
class Queue
{
private:
    int m_count;
    Node<T> * m_front;
    Node<T> * m_back;

public:
    Queue();
    bool IsEmpty();
    T Front();
    void Enqueue(T val);
    void Dequeue();
};

template <typename T>
Queue<T>::Queue() : m_count(0), m_front(NULL), m_back(NULL) {}

template <typename T>
bool Queue<T>::IsEmpty()
{
    // Zwraca true, jeli wystpuje przynajmniej jeden element; w przeciwnym przypadku zwraca false.
    return m_count <= 0;
}

template <typename T>
T Queue<T>::Front()
{
    // Zwraca warto wza m_front.
    return m_front->Value;
}

template <typename T>
void Queue<T>::Enqueue(T val)
{
    // Tworzy nowy wze.
    Node<T> * node = new Node<T>(val);

    if(m_count == 0)
    {
        // Jeli kolejka jest pusta, nowy wze definiowany jest jako m_front i m_back.
        node->Next = NULL;
        m_front = node;
        m_back = m_front;
    }
    else
    {
        // Jeli w kolejce znajduje si co najmniej jeden element, biecy element m_back przestaje by elementem Back,
        // wic wskanik Next biecego m_back wskazuje nowy wze.
        m_back->Next = node;

        // Nowy wze staje si tylnym elementem.
        m_back = node;
    }

    // Dodaje element.
    m_count++;
}

template <typename T>
void Queue<T>::Dequeue()
{
    // Nic nie robi, jeli lista jest pusta.
    if(m_count == 0)
        return;

    // Zapisuje biecy przd w nowym wle.
    Node<T> * node = m_front;

    // Kieruje wskanik Front do elementu nastpujcego po biecym.
    m_front = m_front->Next;

    // Mona bezpiecznie usun pierwszy element.
    delete node;

    // Usuwa element.
    m_count--;
}

#endif // QUEUE_H
