// Projekt: Vector.cbp
// Plik   : main.cpp
#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

void PrintVector(const vector<int>& vect)
{
    for (auto v: vect)
    {
        cout << v << " ";
    }
    cout << endl;
}

int main()
{
	setlocale( LC_ALL, "" );
	
    // Inicjalizuje wektor.
    //vector<int> vectorList = { 35, 41, 94 };

    // Mona te wykorzysta nastpujcy kod:
    vector<int> vectorList;
    vectorList.push_back(35);
    vectorList.push_back(41);
    vectorList.push_back(94);

    // Wywietla biecy vectorList.
    cout << "Elementy vectorList:" << endl;
    PrintVector(vectorList);
    cout << endl;

    // Zwraca warto elementu wedug indeksu.
    int i = vectorList.at(1);
    int j = vectorList[0];

    // Inicjalizuje iterator.
    vector<int>::iterator itr;

    // Wstawia element na pierwsz pozycj.
    itr = vectorList.begin();
    vectorList.insert(itr, 58);

    // Wywietla vectorList.
    cout << "vectorList po wstawieniu elementu:" << endl;
    PrintVector(vectorList);
    cout << endl;

    // Wstawia element na ostatni pozycj.
    itr = vectorList.end();
    vectorList.insert(itr, 37);

    // Wywietla vectorList.
    cout << "vectorList po wstawieniu elementu:" << endl;
    PrintVector(vectorList);
    cout << endl;

    // Umieszcza element na czwartej pozycji.
    itr = vectorList.begin();
    vectorList.insert(itr + 3, 67);

    // Wywietla vectorList.
    cout << "vectorList po wstawieniu elementu:" << endl;
    PrintVector(vectorList);
    cout << endl;

    // Wyszukuje element 41, ktry powinien zosta znaleziony.
    itr = find (vectorList.begin(), vectorList.end(), 41);
    if (itr != vectorList.end())
        cout << "Znaleziono element w vectorList: " << *itr;
    else
        cout << "Nie znaleziono elementu w vectorList";
    cout << endl << endl;

    // Usuwa drugi element.
    itr = vectorList.begin();
    vectorList.erase (itr + 1);

    // Wywietla vectorList.
    cout << "vectorList po usuniciu elementu:" << endl;
    PrintVector(vectorList);
    cout << endl;

    return 0;
}
