// Templates.cbp
#include <iostream>

using namespace std;

class Animal
{
protected:
    string m_name;

public:
    Animal(string name) : m_name(name)
    {

    }

    // Interfejs, ktry trzeba zaimplementowa w klasie pochodnej.
    virtual string MakeSound() = 0;

    string GetName()
    {
        return m_name;
    }

};

class Dog : public Animal
{
public:
    // Przekazuje argumenty konstruktora.
    Dog(string name) : Animal(name) {}

    // Przecia kopiujcy operator przypisania.
    void operator = (const Dog &D)
    {
         m_name = D.m_name;
    }

    // Implementuje interfejs.
    string MakeSound() override
    {
        return "hau, hau!";
    }

};

class Cat : public Animal
{
public:
    // Przekazuje argumenty konstruktora.
    Cat(string name) : Animal(name) {}

    // Przecia kopiujcy operator przypisania.
    void operator = (const Cat &D)
    {
         m_name = D.m_name;
    }

    // Implementuje interfejs.
    string MakeSound() override
    {
        return "miau, miau!";
    }

};

template<typename T>
void GetNameAndMakeSound(T& theAnimal)
{
    cout << theAnimal.GetName() << " robi ";
    cout << theAnimal.MakeSound() << endl;
}

int main()
{
	setlocale( LC_ALL, "" );
	
    Dog dog = Dog("buldog");
    GetNameAndMakeSound(dog);

    Cat cat = Cat("pers");
    GetNameAndMakeSound(cat);

    return 0;
}
