// Projekt: Ternary_Search.cbp
// Plik   : Ternary_Search.cpp

#include <iostream>

using namespace std;

int TernarySearch(
   int arr[],
   int startIndex,
   int endIndex,
   int val)
{
   // Wykonuje wyszukiwanie tylko wtedy,
   // kiedy indeks kocowy ma rwn
   // lub wysz warto od pocztkowego.
   if(startIndex <= endIndex)
   {
      // Znajduje indeks zakresu pierwszej trzeciej czci.
      int middleLeftIndex = startIndex + (endIndex - startIndex) / 3;

      // Znajduje indeks zakresu ostatniej trzeciej czci.
      int middleRightIndex =
      middleLeftIndex + (endIndex - startIndex) / 3;

      // Jeli val znajduje si w indeksie middleLeftIndex,
      // zwraca middleLeftIndex.
      if(arr[middleLeftIndex] == val)
      {
         return middleLeftIndex;
      }
      // Jeli val znajduje si w indeksie middleRightIndex,
      // zwraca middleRightIndex.
      else if(arr[middleRightIndex] == val)
      {
         return middleRightIndex;
      }
      // Jeli val znajduje si w zakresie pierwszej trzeciej,
      // wykonuje kolejne wyszukiwanie ternarne na podtablicy
      // arr[startIndex ... middleLeftIndex - 1].
      else if(arr[middleLeftIndex] > val)
      {
         return TernarySearch(
            arr,
            startIndex,
            middleLeftIndex - 1,
            val);
      }
      // Jeli val znajduje si w zakresie ostatniej trzeciej,
      // wykonuje kolejne wyszukiwanie ternarne na podtablicy
      // arr[middleRightIndex + 1 ... endIndex].
      else if(arr[middleRightIndex] < val)
      {
         return TernarySearch(
            arr,
            middleRightIndex + 1,
            endIndex,
            val);
      }
      // Jeli val znajduje si w zakresie
      // od middleLeftIndex do middleRightIndex, wyszukuje w podtablicy
      // arr[middleLeftIndex + 1 ... middleRightIndex - 1].
      else
      {
         return TernarySearch(
            arr,
            middleLeftIndex + 1,
            middleRightIndex - 1,
            val);
      }
   }
   // W przypadku, gdyby nie znaleziono adnej wartoci:
   return -1;
}

int main()
{
   cout << "Wyszukiwanie ternarne" << endl;

   // Inicjalizuje now tablic.
   int arr[] = {3, 8, 11, 15, 16, 23, 28, 30, 32, 39, 42, 44, 47, 48, 50};
   int arrSize = sizeof(arr)/sizeof(*arr);

   // Definiuje warto do wyszukania.
   int searchedValue = 16;

   // Wyszukuje wskazan warto przy uyciu TernarySearch().
   int i = TernarySearch(arr, 0, arrSize - 1, searchedValue);

   // Powiadamia uytkownika o wyniku,
   // jeeli wyszukiwana warto zostaa znaleziona
   // i funkcja nie zwrcia wyniku -1.
   if(i != -1)
   {
      cout << searchedValue << " znaleziono w indeksie ";
      cout << i << endl;
   }
   else
   {
      cout << "Nie znaleziono wartoci " << searchedValue;
      cout << endl;
   }

   return 0;
}
