// Projekt: Binary_Search.cbp
// Plik   : Binary_Search.cpp

#include <iostream>

using namespace std;

int BinarySearch(
   int arr[],
   int startIndex,
   int endIndex,
   int val)
{
   // Przeprowadza wyszukiwanie tylko wtedy,
   // kiedy indeks kocowy jest wikszy
   // od indeksu startowego lub jemu rwny.
   if(startIndex <= endIndex)
   {
      // Wyszukuje indeks rodkowy.
      int middleIndex = startIndex + (endIndex - startIndex) / 2;

      // Zwraca indeks, jeli warto indeksu rodkowego
      // jest rwna wyszukiwanej wartoci.
      if(arr[middleIndex] == val)
      {
         return middleIndex;
      }
      // Jeli warto indeksu rodkowego jest wysza od wyszukiwanej wartoci,
      // wykonuje kolejne wyszukiwanie binarne w lewej podtablicy.
      // arr[startIndex ... middleIndex - 1]
      else if(arr[middleIndex] > val)
      {
         return BinarySearch(arr, startIndex, middleIndex - 1, val);
      }
      // Jeli warto indeksu rodkowego jest nisza od wyszukiwanej wartoci,
      // wykonuje kolejne wyszukiwanie binarne w prawej podtablicy.
      // arr[middleIndex + 1 ... endIndex]
      else
      {
         return BinarySearch(arr, middleIndex + 1, endIndex, val);
      }
   }

   // W przypadku, gdyby nie znaleziono adnej wartoci:
   return -1;
}

int main()
{
   cout << "Wyszukiwanie binarne" << endl;

   // Inicjalizuje now tablic.
   int arr[] = {3, 8, 11, 15, 16, 23, 28, 30, 32, 39, 42, 44, 47, 48, 50};
   int arrSize = sizeof(arr)/sizeof(*arr);

   // Definiuje warto do wyszukania.
   int searchedValue = 16;

   // Wyszukuje wskazan warto przy uyciu BinarySearch().
   int i = BinarySearch(arr, 0, arrSize - 1, searchedValue);

   // Powiadamia uytkownika o wyniku,
   // jeeli wyszukiwana warto zostaa znaleziona
   // i funkcja nie zwrcia wyniku -1.
   if(i != -1)
   {
      cout << searchedValue << " znaleziono w indeksie ";
      cout << i << endl;
   }
   else
   {
      cout << "Nie znaleziono wartoci " << searchedValue;
      cout << endl;
   }

   return 0;
}
