// Projekt: Parenthesis_Validity.cbp
// Plik   : Parenthesis_Validity.cpp
#include <iostream>
#include <cstring>
#include "../Stack/include/Stack.h"

using namespace std;

bool IsValid (char expression[])
{
    int n = strlen(expression);

    Stack<char> stackChar = Stack<char>();

    for (int i = 0; i < n; ++i)
    {
        // Jeli znak jest nawiasem otwierajcym, zapisuje go w stosie.
        if(expression[i] == '{')
        {
            stackChar.Push('{');
        }
        else if(expression[i] == '[')
        {
            stackChar.Push('[');
        }
        else if(expression[i] == '(')
        {
            stackChar.Push('(');
        }
        // Sprawdza, czy znak jest nawiasem zamykajcym.
        else if (
            expression[i] == '}' ||
            expression[i] == ']' ||
            expression[i] == ')')
        {
            // Jeli stos jest pusty lub ostatni nawias jest inny od tego, ktry wymaga domknicia, wyraenie jest niepoprawne.
            if(expression[i] == '}' &&
               (stackChar.IsEmpty() || stackChar.Top() != '{'))
               return false;
            else if(expression[i] == ']' &&
               (stackChar.IsEmpty() || stackChar.Top() != '['))
               return false;
            else if(expression[i] == ')' &&
               (stackChar.IsEmpty() || stackChar.Top() != '('))
               return false;
            else
                stackChar.Pop();
        }
    }

    // Jeli stos jest pusty, wyraenie jest poprawne; w przeciwnym przypadku jest niepoprawne.
    if (stackChar.IsEmpty())
        return true; //
    else
        return false;
}

int main()
{
setlocale( LC_ALL, "" );

   // Przygotowuje tablic
   // do przechowania wyraenia.
   char expr[1000];

   // Prosi uytkownika o wprowadzenie wyraenia.
   cout << "Podaj wyraenie nawiasowe ";
   cout << "i nacinij ENTER." << endl;
   cin >> expr;

   // Sprawdza poprawno.
   bool bo = IsValid(expr);

   // Powiadamia uytkownika.
   cout << endl;
   cout << "Wyraenie " << expr << " jest ";
   if(bo)
      cout << "poprawne";
   else
      cout << "niepoprawne";
   cout << endl;

   return 0;
}


