// Projekt: Std_List.cbp
// Plik   : main.cpp
#include <iostream>
#include <list>
#include <algorithm>

using namespace std;

void PrintLinkedList(const list<int>& llist)
{
    for (auto l : llist)
    {
        std::cout << l << " -> ";
    }
    cout << "NULL" << endl;
}

list<int>::iterator GetIterator(list<int>::iterator it, int x)
{
    for(int i = 0; i < x; ++i, ++it);
    return it;
}

int main()
{
   setlocale( LC_ALL, "" );
   
   // Inicjalizuje list wizan.
   list<int> linkedList;

   // 43->NULL
   linkedList.push_front(43);

   // 76->43->NULL
   linkedList.push_front(76);

   // 76->43->15->NULL
   linkedList.push_back(15);

   // 76->43->15->44->NULL
   linkedList.push_back(44);

   // Wywietla element listy.
   cout << "Pierwszy:" << endl;
   PrintLinkedList(linkedList);
   cout << endl;

   // 76->43->15->44->100->NULL
   list<int>::iterator itr = GetIterator(linkedList.begin(), 4);
   linkedList.insert(itr, 100);

   // 76->43->15->48->44->100->NULL
   itr = GetIterator(linkedList.begin(), 3);
   linkedList.insert(itr, 48);

   // 22->76->43->15->48->44->100->NULL
   linkedList.insert(linkedList.begin(), 22);

   // Wywietla element listy.
   cout << "Drugi:" << endl;
   PrintLinkedList(linkedList);
   cout << endl;

   // Pobiera warto drugiego indeksu,
   // ktra powinna wynosi 43.
   cout << "Pobieranie wartoci drugiego indeksu:" << endl;
   itr = GetIterator(linkedList.begin(), 2);
   if(itr != linkedList.end())
      cout << *itr;
   else
      cout << "nie znaleziono";
   cout << endl << endl;

   // Wyszukuje pozycj wartoci 15,
   // ktra powinna zosta znaleziona.
   itr = find (linkedList.begin(), linkedList.end(), 15);
   if (itr != linkedList.end())
      cout << "Znaleziono element w linkedList: " << *itr;
   else
      cout << "Nie znaleziono elementu w linkedList";
   cout << endl << endl;

   // Usuwa pierwszy element.
   cout << "Usuwanie pierwszego elementu:" << endl;
   itr = linkedList.begin();
   linkedList.erase (itr);
   // 76->43->15->48->44->100->NULL
   PrintLinkedList(linkedList);
   cout << endl;

   // Usuwa pity element.
   cout << "Usuwanie pitego elementu:" << endl;
   itr = GetIterator(linkedList.begin(), 4);
   linkedList.erase (itr);
   // 76->43->15->48->100->NULL
   PrintLinkedList(linkedList);
   cout << endl;

return 0;
}
