/*
 * dyrektywy #include jak na listingu 14.20
 */

using namespace std;
using namespace xercesc;
using namespace xalanc;

/*
 * definicja XalanInitializer jak na listingu 14.20
 */

int main( )
{
    try {
        XalanInitializer    init;     // inicjalizacja infrastruktury Xalan
        XalanTransformer    xslt;     // obiekt transformacji XSLT
        XSLTResultTarget    html("cyrk.html"); // wynik przeksztacania

        // Parse source
        XSLTInputSource     xml("cyrk.xml");
        XalanParsedSource*  parsedXml = 0; 
        if (xslt.parseSource(xml, parsedXml) != 0) {
            cout << "bd xml: " << xslt.getLastError( ) << "\n";
        }

        // kompilacja arkusza XSL
        XSLTInputSource           xsl("cyrk.xsl");
        XalanCompiledStylesheet*  compiledXsl = 0;
        if (xslt.compileStylesheet(xsl, compiledXsl) != 0) {
            cout << "bd xml: " << xslt.getLastError( ) << "\n";
        }

        // waciwe przeksztacanie
        if (xslt.transform(xml, xsl, html)) {
            cout << "bd xml: " << xslt.getLastError( ) << "\n";
        }
    } catch (const XMLException& e) {
        cout << "bd xml: " << toNative(e.getMessage( )) << "\n";
        return EXIT_FAILURE;
    } catch (const exception& e) {
        cout << e.what( ) << "\n";
        return EXIT_FAILURE;



    }
}