#include <iostream>
#include <string>
#include <cstdlib>
#include <boost/filesystem/operations.hpp>
#include <boost/filesystem/fstream.hpp>

using namespace std;
using namespace boost::filesystem;

void removeRecurse(const path& p) {

   // usunicie zawartoci katalogu...
   directory_iterator end;
   for (directory_iterator it(p);
        it != end; ++it) {

      if (is_directory(*it)) {
         removeRecurse(*it);
      }
      else {
         remove(*it);
      }
   }
   // ...a nastpnie samego katalogu
   remove(p);
}

int main(int argc, char** argv) {

   if (argc != 2) {
      cerr << "Stosowanie: " << argv[0] << " [nazwa katalogu]\n";
      return(EXIT_FAILURE);
   }

   path thePath = system_complete(path(argv[1], native));

   if (!exists(thePath)) {
      cerr << "Bd: katalog " << thePath.string( )
           << " nie istnieje.\n";
      return(EXIT_FAILURE);
   }

   try {
      removeRecurse(thePath);
   }
   catch (exception& e) {
      cerr << e.what( ) << endl;
      return(EXIT_FAILURE);
   }
   return(EXIT_SUCCESS);
}