#include <iostream>
#include <iomanip>
#include <string>
#include <vector>

using namespace std;

// TableFormatter formatuje dane do wypisania 
// do strumienia znakw typu T.
template<typename T>
class TableFormatter {

public:
   TableFormatter(basic_ostream<T>& os) : out_(os) {}
  ~TableFormatter( ) {out_ << flush;}

   template<typename valT>
   void writeTableRow(const vector<valT>& v, int width);
   //...

private:
  basic_ostream<T>& out_;
};

template<typename T>    // dotyczy listy parametrw szablonu klasy
template<typename valT> // dotyczy listy parametrw szablonu metody klasy
void TableFormatter<T>::writeTableRow(const std::vector<valT>& v,
                                      int width) {

   ios_base::fmtflags flags = out_.flags( );

   out_.flush( );
   out_ << setprecision(2) << fixed;  // ustawienie precyzji dla wartoci zmiennoprzecinkowych

   for (vector<valT>::const_iterator p = v.begin( );
        p != v.end( ); ++p)
     out_ << setw(width) << left << *p;  // ustalenie szerokoci pola wyjciowego, wyrwnania
                                         // i zapisanie elementu do strumienia
   out_ << endl;     // oprnienie bufora strumienia
   out_.setf(flags); // przywrcenie pierwotnych znacznikw strumienia
}

int main( ) {

   TableFormatter<char> fmt(cout);

   vector<string> vs;

   vs.push_back( "Niedziela" );
   vs.push_back( "Poniedziaek" );
   vs.push_back( "Wtorek" );

   fmt.writeTableRow(vs, 12);
   fmt.writeTableRow(vs, 12);
   fmt.writeTableRow(vs, 12);

   vector<double> vd;

   vd.push_back(4.0);
   vd.push_back(3.0);
   vd.push_back(2.0);
   vd.push_back(1.0);

   fmt.writeTableRow(vd, 5);
}