#include <iostream>
#include <locale>
#include <string>
#include <sstream>

using namespace std;

long double readMoney(istream& in, bool intl = false) {

   long double val;

   // utworzenie aspektu "czytnika"
   const money_get<char>& moneyReader =
     use_facet<money_get<char> >(in.getloc( ));

   // znacznik koca bufora
   istreambuf_iterator<char> end;

   // zmienna stanu, sygnalizujca skuteczno odczytu
   ios_base::iostate state = 0;

   moneyReader.get(in, end, intl, in, state, val);

   // jeli co pjdzie nie tak, metoda get ustawi znacznik failbit
   if (state != 0 && !(state & ios_base::eofbit))
      throw "Nie mona wczyta wartoci ze strumienia!\n";

   return(val);
}

void writeMoney(ostream& out, long double val, bool intl = false) {

   // utworzenie aspektu zapisujcego
   const money_put<char>& moneyWriter =
     use_facet<money_put<char> >(out.getloc( ));

   // zapisujemy warto do strumienia; wywoanie failed() (zwracajce warto
   // typu ostreambuf_iterator) upewni nas, czy skutecznie
   if (moneyWriter.put(out, intl, out, out.fill( ), val).failed( ))
      throw "Nie mona zapisa do strumienia!\n";
}

int main( ) {

   long double val = 0;
   float exchangeRate = 3.25987f;  // dolary na zote
   locale locEn("english");
   locale locFr("polish");

   cout << "Dolary: ";
   cin.imbue(locEn);
   val = readMoney(cin, false);

   cout.imbue(locFr);
   // ustawienie znacznika showbase wymuszajcego
   // wyprowadzenie symbolu waluty
   cout.setf(ios_base::showbase);
   cout << "Zote: ";
   writeMoney(cout, val * exchangeRate, true);
}