#include <iostream>
#include <ctime>
#include <sys/types.h>
#include <sys/stat.h>
#include <cerrno>
#include <cstring>

int main(int argc, char** argv )
{
   struct stat fileInfo;

   if (argc < 2) {
      std::cout << "Stosowanie: fileinfo <nazwa pliku>\n";
      return(EXIT_FAILURE);
   }

   if (stat(argv[1], &fileInfo) != 0) {  // funkcja stat() zwraca informacje
      std::cerr << "Bd: " << strerror(errno) << '\n';
      return(EXIT_FAILURE);
   }

   std::cout << "Typ:          : ";
   if ((fileInfo.st_mode & S_IFMT) == S_IFDIR) { // z sys/types.h
      std::cout << "katalog\n";
   } else {
      std::cout << "plik\n";
   }

   std::cout << "Rozmiar       : " <<
      fileInfo.st_size << '\n';               // rozmiar w bajtach
   std::cout << "Urzdzenie    : " <<
      (char)(fileInfo.st_dev + 'A') << '\n';  // numer urzdzenia
   std::cout << "Utworzony     : " <<
      std::ctime(&fileInfo.st_ctime);         // czas utworzenia
   std::cout << "Zmodfikowany  : " <<
      std::ctime(&fileInfo.st_mtime);         // czas ostatniej modyfikacji
}