#include <stdexcept>                       // runtime_error
#include <vector>
#include <xercesc/sax2/Attributes.hpp>
#include <xercesc/sax2/DefaultHandler.hpp> // zawiera domylne (puste) 
                                           // implementacje rnych
                                           // klas obsugi
#include "xerces_strings.hpp"              // listing 14-4
#include "animal.hpp"

using namespace std;
using namespace xercesc;

// zwraca egzemplarz klasy Contact utworzony 
// na podstawie przekazanego zestawu atrybutw
Contact contactFromAttributes(const Attributes &attrs)
{
    // gwoli wydajnoci najczciej stosowane cigi 
    // przechowujemy w zmiennych statycznych
    static XercesString name = fromNative("name");
    static XercesString phone = fromNative("phone");

    Contact result;    // obiekt zwracany
    const XMLCh* val;  // warto atrybutu name bd phone

    // ustawienie skadowej name obiektu zwracanego
    if ((val = attrs.getValue(name.c_str( ))) != 0) {
        result.setName(toNative(val));
    } else {
        throw runtime_error("brak atrybutu \"name\"");
    }

    // ustawienie skadowej phone obiektu zwracanego
    if ((val = attrs.getValue(phone.c_str( ))) != 0) {
        result.setPhone(toNative(val));
    } else {
        throw runtime_error("brak atrybutu \"phone\"");
    }

    return result;
}

// implementuje wywoania zwrotne odbierajce dane znakowe i powiadomienia
// o wykryciu pocztkw i kocw poszczeglnych elementw 
class CircusContentHandler : public DefaultHandler {
public:
    CircusContentHandler(vector<Animal>& animalList) 
        : animalList_(animalList)
        { }

    // jeli biecy element reprezentuje opiekuna albo tresera,
    // jego atrybuty posu do konstruowania obiektu Contact dla
    // biecego obiektu Animal; w innych przypadkach czycimy currentText_
    // przygotowujc si do wywoania zwrotnego characters( )
    void startElement( 
           const XMLCh *const uri,        // URI przestrzeni nazw 
           const XMLCh *const localname,  // znacznik bez przedrostka przestrzeni nazw
           const XMLCh *const qname,      // znacznik z przedrostkiem przestrzeni nazw
           const Attributes &attrs )      // atrybuty elementu
    {
        static XercesString animalList = fromNative("animalList");
        static XercesString animal = fromNative("animal");
        static XercesString vet = fromNative("veterinarian");
        static XercesString trainer = fromNative("trainer");
        static XercesString xmlns = 
            fromNative("http://www.feldman-family-circus.com");

        // weryfikacja URI przestrzeni nazw
        if (uri != xmlns)
            throw runtime_error(
                      string("niepoprawny URI przestrzeni nazw: ") + toNative(uri)
                  );
        if (localname == animal) {
            // dodanie obiektu Animal do listy; to nowy
            // "biecy zwierzak"
            animalList_.push_back(Animal( ));
        } else if (localname!= animalList) {
            Animal& animal = animalList_.back( );
            if (localname == vet) {
                // mamy tu element "veterinarian" (opiekun)
                animal.setVeterinarian(contactFromAttributes(attrs));
            } else if (localname == trainer) {
                // mamy tu element "trainer" (treser)
                animal.setTrainer(contactFromAttributes(attrs));
            } else {
                // mamy tu elementy "name", "species" albo
                // "dateOfBirth"; ich zawarto zostanie przekazana
                // do funkcji zwrotnej characters( ).
                currentText_.clear( );
            }
        }
    }

    // jeli biecy element reprezentuje imi, gatunek albo dat urodzenia
    // zwierzaka, ustawiamy odpowiednie skadowe obiektu Animal zgodnie z 
    // zawartoci currentText_
    void endElement(          
           const XMLCh *const uri,        // URI przestrzeni nazw
           const XMLCh *const localname,  // znacznik bez przedrostka przestrzeni nazw
           const XMLCh *const qname )     // znacznik z przedrostkiem przestrzeni nazw
    {
        static XercesString animalList = fromNative("animal-list");
        static XercesString animal = fromNative("animal");
        static XercesString name = fromNative("name");
        static XercesString species = fromNative("species");
        static XercesString dob = fromNative("dateOfBirth");

        if (localname!= animal && localname!= animalList) {
            // currentText_ zawiera zawarto koczcego si elementu;
            // wykorzystamy go do ustawienia skadowych obiektu biecego
            // zwierzaka
            Animal& animal = animalList_.back( );
            if (localname == name) {
                animal.setName(toNative(currentText_));
            } else if (localname == species) {
                animal.setSpecies(toNative(currentText_));
            } else if (localname == dob) {
                animal.setDateOfBirth(toNative(currentText_));
            } 
        }
    }
    // odbiera powiadomienia o napotkaniu w dokumencie danych znakowych
    void characters( const XMLCh* const chars, 
                     const unsigned int length ) 
    {
        // doczenie znakw do currentText_ celem pniejszego
        // przetworzenia w ramach metody endElement( )
        currentText_.append(chars, length);
    }
private:
    vector<Animal>&  animalList_;
    XercesString     currentText_;
};