#include <iostream>
#include <map>
#include <string>

using namespace std;

class Person {
   friend class PersonLessThan;
public:
   Person(const string& first, const string& last) :
      lastName_(last), firstName_(first) {}
   // ...
   string getFirstName( ) const {return(firstName_);}
   string getLastName( ) const {return(lastName_);}
private:
   string lastName_;
   string firstName_;
};

class PersonLessThan {
public:
   bool operator( )(const Person& per1,
                   const Person& per2) const {
      if (per1.lastName_ < per2.lastName_)          // porwnanie nazwisk,
         return(true);                              // potem imion
      else if (per1.lastName_ == per2.lastName_)
         return(per1.firstName_ < per2.firstName_);
      else
         return(false);
   }
};

int main( ) {

   map<Person, string, PersonLessThan> personMap;

   Person per1("Tolek", "Banan"),
      per2("Janek", "Muzykant"),
      per3("Franek", "Kimono"),
      per4("Albert", "Einstein");

   personMap[per1] = "fajny";
   personMap[per2] = "mniej fajny";
   personMap[per3] = "mniej fajny";
   personMap[per4] = "fajny";

   for (map<Person, string, PersonLessThan>::const_iterator p =
        personMap.begin( ); p != personMap.end( ); ++p) {
      cout << p->first.getFirstName( ) << " " << p->first.getLastName( )
           << " jest " << p->second << endl;
   }
}
