#include <iostream>
#include <fstream>
#include <string>
#include <cstdlib>

using namespace std;
const static char PAD_CHAR = '.';

// funkcja addMargins przyjmuje na wejciu dwa strumienie i dwie liczby.
// strumienie reprezentuj wejcie i wyjcie, za pierwsza z to rozmiar
// lewego marginesu (czyli liczba spacji do wstawienia na pocztku kadego
// wiersza tekstu). Druga liczba reprezentuje czn dugo wiersza,
// okrelajc porednio rozmiar dopenienia wiersza.
void addMargins(istream& in, ostream& out,
                int left, int right) {

   string tmp;

   while (!in.eof( )) {
      getline(in, tmp, '\n');                     // definicja getline
                                                  // znajduje si w <string>
      tmp.insert(tmp.begin( ), left, PAD_CHAR);
      rpad(tmp, right, PAD_CHAR);                 // funkcja wzorowana na funkcji
                                                  // pad z receptury 4.1
      out << tmp << '\n';
   }
}

int main(int argc, char** argv) {

   if (argc < 3)
      return(EXIT_FAILURE);

   ifstream in(argv[1]);
   ofstream out(argv[2]);

   if (!in || !out)
      return(EXIT_FAILURE);

   int left = 8;
   int right = 72;

   if (argc == 5) {
      left = atoi(argv[3]);
      right = atoi(argv[4]);
   }

   addMargins(in, out, left, right);

   out.close( );

   if (out)
      return(EXIT_SUCCESS);
   else
      return(EXIT_FAILURE);
}
