/**************************************************************************************************
*
* \file G34_Non_Owning_Type_Erasure_1.cpp
* \brief Wytyczna 34.: Pamiętaj o kosztach konfiguracji związanych z rodzajem opakowań używanych we wzorcu Ukrywanie typu
*
* Copyright (C) 2022 Klaus Iglberger - wszystkie prawa zastrzeżone
*
* Ten plik należy do materiałów uzupełniających do książki "Projektowanie oprogramowania w języku C++"
* wydanej przez wydawnictwo Helion.
*
**************************************************************************************************/


//---- <Circle.h> ---------------------------------------------------------------------------------

class Circle
{
 public:
   explicit Circle( double radius )
      : radius_( radius )
   {}

   double radius() const { return radius_; }
   /* Kilka innych funkcji pobierających i pomocniczych związanych z okręgami */

 private:
   double radius_;
   /* Kilka kolejnych danych składowych */
};


//---- <Square.h> ---------------------------------------------------------------------------------

class Square
{
 public:
   explicit Square( double side )
      : side_( side )
   {}

   double side() const { return side_; }
   /* Kilka innych funkcji pobierających i pomocniczych związanych z kwadratami */

 private:
   double side_;
   /* Kilka kolejnych danych składowych */
};


//---- <Shape.h> ----------------------------------------------------------------------------------

#include <memory>

class ShapeConstRef
{
 public:
   template< typename ShapeT, typename DrawStrategy >
   ShapeConstRef( ShapeT& shape, DrawStrategy& drawer )
      : shape_{ std::addressof(shape) }
      , drawer_{ std::addressof(drawer) }
      , draw_{ []( void const* shapeBytes, void const* drawerBytes ){
           auto const* shape = static_cast<ShapeT const*>(shapeBytes);
           auto const* drawer = static_cast<DrawStrategy const*>(drawerBytes);
           (*drawer)( *shape );
        } }
   {}

 private:
   friend void draw( ShapeConstRef const& shape )
   {
      shape.draw_( shape.shape_, shape.drawer_ );
   }

   using DrawOperation = void( void const*,void const* );

   void const* shape_{ nullptr };
   void const* drawer_{ nullptr };
   DrawOperation* draw_{ nullptr };
};


//---- <Main.cpp> ---------------------------------------------------------------------------------

//#include <Circle.h>
//#include <Shape.h>
#include <cstdlib>

void useShapeConstRef( ShapeConstRef shape )
{
   draw( shape );
}

int main()
{
   // Tworzymy okrąg jako reprezentanta konkretnego typu figury
   Circle circle{ 3.14 };

   // Tworzymy strategię rysowania w formie wyrażenia lambda
   auto drawer = []( Circle const& c ){ /*...*/ };

   // Rysujemy okrąg bezpośrednio przy użyciu abstrakcji 'ShapeConstRef'
   useShapeConstRef( { circle, drawer } );

   return EXIT_SUCCESS;
}

