/**************************************************************************************************
*
* \file G33_Manual_Virtual_Dispatch.cpp
* \brief Wytyczna 33.: Miej świadomość optymalizacyjnego potencjału wzorca projektowego Ukrywanie typu
*
* Copyright (C) 2022 Klaus Iglberger - wszystkie prawa zastrzeżone
*
* Ten plik należy do materiałów uzupełniających do książki "Projektowanie oprogramowania w języku C++"
* wydanej przez wydawnictwo Helion.
*
**************************************************************************************************/


//---- <Circle.h> ---------------------------------------------------------------------------------

class Circle
{
 public:
   explicit Circle( double radius )
      : radius_( radius )
   {}

   double radius() const { return radius_; }
   /* Kilka innych funkcji pobierających i pomocniczych związanych z okręgami */

 private:
   double radius_;
   /* Kilka kolejnych danych składowych */
};


//---- <Square.h> ---------------------------------------------------------------------------------

class Square
{
 public:
   explicit Square( double side )
      : side_( side )
   {}

   double side() const { return side_; }
   /* Kilka innych funkcji pobierających i pomocniczych związanych z kwadratami */

 private:
   double side_;
   /* Kilka kolejnych danych składowych */
};


//---- <Shape.h> ----------------------------------------------------------------------------------

#include <cstddef>
#include <memory>

class Shape
{
 public:
   template< typename ShapeT
           , typename DrawStrategy >
   Shape( ShapeT shape, DrawStrategy drawer )
      : pimpl_(
            new OwningModel<ShapeT,DrawStrategy>( std::move(shape)
                                                , std::move(drawer) )
          , []( void* shapeBytes ){
               using Model = OwningModel<ShapeT,DrawStrategy>;
               auto* const model = static_cast<Model*>(shapeBytes);
               delete model;
            } )
      , draw_(
            []( void* shapeBytes ){
               using Model = OwningModel<ShapeT,DrawStrategy>;
               auto* const model = static_cast<Model*>(shapeBytes);
               (model->drawer_)( model->shape_ );
            } )
      , clone_(
            []( void* shapeBytes ) -> void* {
               using Model = OwningModel<ShapeT,DrawStrategy>;
               auto* const model = static_cast<Model*>(shapeBytes);
               return new Model( *model );
            } )
   {}

   Shape( Shape const& other )
      : pimpl_( other.clone_( other.pimpl_.get() ), other.pimpl_.get_deleter() )
      , draw_ ( other.draw_ )
      , clone_( other.clone_ )
   {}

   Shape& operator=( Shape const& other )
   {
      // Idiom kopiuj i zamień
      using std::swap;
      Shape copy( other );
      swap( pimpl_, copy.pimpl_ );
      swap( draw_, copy.draw_ );
      swap( clone_, copy.clone_ );
      return *this;
   }

   ~Shape() = default;
   Shape( Shape&& ) = default;
   Shape& operator=( Shape&& ) = default;

 private:
   friend void draw( Shape const& shape )
   {
      shape.draw_( shape.pimpl_.get() );
   }

   template< typename ShapeT
           , typename DrawStrategy >
   struct OwningModel
   {
      OwningModel( ShapeT value, DrawStrategy drawer )
         : shape_( std::move(value) )
         , drawer_( std::move(drawer) )
      {}

      ShapeT shape_;
      DrawStrategy drawer_;
   };

   using DestroyOperation = void(void*);
   using DrawOperation    = void(void*);
   using CloneOperation   = void*(void*);

   std::unique_ptr<void,DestroyOperation*> pimpl_;
   DrawOperation*  draw_ { nullptr };
   CloneOperation* clone_{ nullptr };
};


//---- <Main.cpp> ---------------------------------------------------------------------------------

//#include <Circle.h>
//#include <Square.h>
//#include <Shape.h>
#include <cstdlib>

int main()
{
   // Tworzymy okrąg jako jednego reprezentanta konkretnych typów figur
   Circle circle{ 3.14 };

   // Tworzymy strategię rysowania w formie wyrażenia lambda
   auto drawer = []( Circle const& c ){ /*...*/ };

   // Łączymy figurę oraz strategię rysowania w abstrakcji Shape.
   // Ten konstruktor skonkretyzuje typ 'deatail::OwningShapeModel' dla 
   // podanego typu 'Circle' oraz podanego typu wyrażenia lambda
   Shape shape1( circle, drawer );

   // Rysujemy figurę
   draw( shape1 );

   // Tworzymy kopię figury przy użyciu konstruktora kopiującego
   Shape shape2( shape1 );

   // Narysowanie tej kopii da takie same wyniki
   draw( shape2 );

   return EXIT_SUCCESS;
}

