/**************************************************************************************************
*
* \file G31_External_Polymorphism.cpp
* \brief Wytyczna 31.: Stosuj wzorzec Polimorfizm zewnętrzny, by tworzyć nieintruzyjny polimorfizm czasu wykonywania 
*
* Copyright (C) 2022 Klaus Iglberger - wszystkie prawa zastrzeżone
*
* Ten plik należy do materiałów uzupełniających do książki "Projektowanie oprogramowania w języku C++"
* wydanej przez wydawnictwo Helion.
*
**************************************************************************************************/


//---- <Circle.h> ---------------------------------------------------------------------------------

class Circle
{
 public:
   explicit Circle( double radius )
      : radius_( radius )
   {
      /* Sprawdzenie, czy podany promień jest poprawny */
   }

   double radius() const { return radius_; }
   /* Kilka innych funkcji pobierających i pomocniczych związanych z okręgami */

 private:
   double radius_;
   /* Kilka kolejnych danych składowych */
};


//---- <Square.h> ---------------------------------------------------------------------------------

class Square
{
 public:
   explicit Square( double side )
      : side_( side )
   {
      /* Sprawdzenie, czy podana długość krawędzi jest poprawna */
   }

   double side() const { return side_; }
   /* Kilka innych funkcji pobierających i pomocniczych związanych z kwadratami */

 private:
   double side_;
   /* Kilka kolejnych danych składowych */
};


//---- <Shape.h> ----------------------------------------------------------------------------------

#include <functional>
#include <stdexcept>
#include <utility>

class ShapeConcept
{
 public:
   virtual ~ShapeConcept() = default;

   virtual void draw() const = 0;

   // ... Potencjalnie więcej operacji polimorficznych
};


template< typename ShapeT
        , typename DrawStrategy >
class ShapeModel : public ShapeConcept
{
 public:
   explicit ShapeModel( ShapeT shape, DrawStrategy drawer )
      : shape_{ std::move(shape) }
      , drawer_{ std::move(drawer) }
   {}

   void draw() const override { drawer_(shape_); }

 private:
   ShapeT shape_;
   DrawStrategy drawer_;
};


//---- <OpenGLDrawStrategy.h> ---------------------------------------------------------------------

//#include <Circle.h>
//#include <Square.h>
//#include /* Nagłówki biblioteki graficznej OpenGL */

class OpenGLDrawStrategy
{
 public:
   explicit OpenGLDrawStrategy( /* Argumenty związane z rysowaniem */ )
   {}

   void operator()( Circle const& circle ) const
   {
      // ... Implementacja rysowania okręgu przy użyciu OpenGL
   }
   void operator()( Square const& square ) const
   {
      // ... Implementacja rysowania kwadratu przy użyciu OpenGL
   }

 private:
   /* Dane składowe związane z rysowaniem, takie jak kolory, tekstury ... */
};


//---- <Main.cpp> ---------------------------------------------------------------------------------

//#include <Circle.h>
//#include <Square.h>
//#include <Shape.h>
//#include <OpenGLDrawStrategy.h>
#include <memory>
#include <vector>

int main()
{
   using Shapes = std::vector<std::unique_ptr<ShapeConcept>>;

   using CircleModel = ShapeModel<Circle,OpenGLDrawStrategy>;
   using SquareModel = ShapeModel<Square,OpenGLDrawStrategy>;

   Shapes shapes{};

   // Tworzymy kilka figur, przy czym każda z nich będzie korzystać ze 
   // strategii rysowania OpenGL 
   shapes.emplace_back(
      std::make_unique<CircleModel>(
         Circle{2.3}, OpenGLDrawStrategy(/*... czerwony ...*/) ) );
   shapes.emplace_back(
      std::make_unique<SquareModel>(
         Square{1.2}, OpenGLDrawStrategy(/*... zielony ...*/) ) );
   shapes.emplace_back(
      std::make_unique<CircleModel>(
         Circle{4.1}, OpenGLDrawStrategy(/*... niebieski ...*/) ) );

   // Rysujemy wszystkie figury
   for( auto const& shape : shapes )
   {
      shape->draw();
   }

   return EXIT_SUCCESS;
}

