/**************************************************************************************************
*
* \file G22_Example_1.cpp
* \brief Wytyczna 22.: Preferuj semantykę wartości od semantyki referencji
*
* Copyright (C) 2022 Klaus Iglberger - wszystkie prawa zastrzeżone
*
* Ten plik należy do materiałów uzupełniających do książki "Projektowanie oprogramowania w języku C++"
* wydanej przez wydawnictwo Helion.
*
**************************************************************************************************/


#include <cstdlib>
#include <iostream>
#include <span>
#include <vector>

void print( std::span<int> s )
{
   std::cout << " (";
   for( int i : s ) {
      std::cout << ' ' << i;
   }
   std::cout << " )\n";
}

int main()
{
   std::vector<int> v{ 1, 2, 3, 4 };

   std::vector<int> const w{ v };
   std::span<int> const s{ v };

   //w[2] = 99;  // Błąd kompilacji!
   s[2] = 99;  // To działa!

   // Wyświetla ( 1 2 99 4 );
   print( s );

   v = { 5, 6, 7, 8, 9 };
   s[2] = 99;  // To działa!

   // Wyświetla?
   print( s );

   return EXIT_SUCCESS;
}

