#include <algorithm>
#include <list>
#include <string>
#include <iostream>
using namespace std;

template <typename T>
void DisplayContents (const T& Input)
{
   for(auto iElement = Input.cbegin() // auto i cbegin(): C++11.
      ; iElement != Input.cend() // cend() to nowość w C++11.
      ; ++ iElement )
      cout << *iElement << endl;
}
int main ()
{
    list<string> listNames;

    // Wstawienie wartości przykładowych.
    listNames.push_back ("Cezary Pazura");
    listNames.push_back ("Robert Gonera");
    listNames.push_back ("Marek Kondrat");
    listNames.push_back ("Marek Perepeczko");
    listNames.push_back ("Anna Dereszowska");

    cout << "Posortowany obiekt list zawiera elementy w następującej kolejności: " << endl;
    listNames.sort();
    DisplayContents(listNames);

    cout << "Najniższa wartość indeksu, w którym można umieścić element \"Robert Gonera\" to: ";
    auto iMinInsertPos = lower_bound ( listNames.begin (), listNames.end ()
       , "Robert Gonera" );
    cout << distance (listNames.begin (), iMinInsertPos) << endl;

    cout << "Najwyższa wartość indeksu, w którym można umieścić element \"Robert Gonera\" to: ";
    auto iMaxInsertPos = upper_bound ( listNames.begin (), listNames.end ()
       , "Robert Gonera" );
    cout << distance (listNames.begin (), iMaxInsertPos) << endl;

    cout << endl;

    cout << "Obiekt list po wstawieniu elementu Robert Gonera: " << endl;
    listNames.insert (iMinInsertPos, "Robert Gonera");

    DisplayContents(listNames);
    return 0;
}
