// W tym miejscu wstaw klasę CompareStringNoCase z listingu 21.6.
#include <vector>
#include <iostream>

template <typename T>
void DisplayContents (const T& Input)
{
   for(auto iElement = Input.cbegin() // auto, cbegin i cend: c++11.
      ; iElement != Input.cend ()
      ; ++ iElement )
      cout << *iElement << endl;
}

int main ()
{
    // Zdefiniowanie zbioru ciągów tekstowych przechowujących imiona.
    vector<string> vecNames;

    // Wstawienie do zbioru kilku przykładowych imion.
    vecNames.push_back ("jan");
    vecNames.push_back ("Jacek");
    vecNames.push_back ("Stefan");
    vecNames.push_back ("Anna");

    cout << "Imiona w zbiorze wymienione w kolejności wstawiania: " << endl;
    DisplayContents(vecNames);

   cout << "Imiona posortowane przy użyciu domyślnego predykatu std::less<>: " << endl;
   sort(vecNames.begin(), vecNames.end());
   DisplayContents(vecNames);

   cout << "Imiona posortowane przy użyciu domyślnego predykatu ignorującego wielkość liter:" << endl;
   sort(vecNames.begin(), vecNames.end(), CompareStringNoCase());
   DisplayContents(vecNames);

    return 0;
}
