#include <list>
#include <iostream>
using namespace std;

template <typename T>
void DisplayContents(const T& Input)
{
    for (auto iElement = Input.cbegin() // auto i cbegin() dla C++11.
        ; iElement != Input.cend()
        ; ++ iElement )
       cout << *iElement << ' '; 

    cout << endl;
}

int main ()
{
    list <int> listIntegers1;

    // Wstawianie elementów na początku...
    listIntegers1.insert (listIntegers1.begin (), 2);
    listIntegers1.insert (listIntegers1.begin (), 1);

    // Wstawianie elementów na końcu...
    listIntegers1.insert (listIntegers1.end (), 3);

    cout << "Zawartość obiektu list1 po wstawieniu elementów: " << endl;
    DisplayContents (listIntegers1);

    list <int> listIntegers2;

    // Wstawienie czterech elementów wraz z tą samą wartością 0...
    listIntegers2.insert (listIntegers2.begin (), 4, 0);

    cout << "Zawartość obiektu list2 po wstawieniu '";
    cout << listIntegers2.size () << "' elementów o wartości:" << endl;
    DisplayContents (listIntegers2);

    list <int> listIntegers3;

    // Wstawienie na początku elementów pochodzących z innego obiektu list...
    listIntegers3.insert (listIntegers3.begin (), 
                          listIntegers1.begin (), listIntegers1.end ());

    cout << "Zawartość obiektu list3 po wstawieniu na początku ";
    cout << "zawartości obiektu list1:" << endl;
    DisplayContents (listIntegers3);

    // Wstawienie na końcu elementów pochodzących z innego obiektu list... 
    listIntegers3.insert (listIntegers3.end (), 
                        listIntegers2.begin (), listIntegers2.end ());

    cout << "Zawartość obiektu list3 po wstawieniu na początku ";
    cout << "zawartości obiektu list2:" << endl;
    DisplayContents (listIntegers3);

    return 0;
}
