#include <iostream>
#include <algorithm>
#include <vector>
using namespace std;

template <typename T>
void DisplayContents (const T& Input)
{
   for(auto iElement = Input.cbegin() // auto i cbegin(): C++11.
      ; iElement != Input.cend() // cend() to nowość w C++11.
      ; ++ iElement )
      cout << *iElement << ' ';

   cout << " | Liczba elementów: " << Input.size() << endl;
}
int main ()
{
    vector <int> vecIntegers (6);

    // Wypełnienie pierwszych trzech elementów wartością 8, ostatnich trzech wartością 5.
    fill (vecIntegers.begin (), vecIntegers.begin () + 3, 8);
    fill_n (vecIntegers.begin () + 3, 3, 5);

    // Umieszczenie elementów kontenera w losowej kolejności.
    random_shuffle (vecIntegers.begin (), vecIntegers.end ());
    
    cout << "Początkowa zawartość obiektu vector jest następująca: " << endl;
    DisplayContents(vecIntegers);

    cout << endl << "Użycie funkcji 'std::replace' w celu zastąpienia wartości 5 przez wartość 8" << endl;
    replace (vecIntegers.begin (), vecIntegers.end (), 5, 8);

    cout << "Użycie funkcji 'std::replace_if' w celu zastąpienia liczb parzystych przez wartość -1" << endl;
    replace_if (vecIntegers.begin (), vecIntegers.end ()
       , [](int element) {return ((element % 2) == 0); }, -1);

    cout << endl << "Zawartość obiektu vector po operacjach zastępowania:" << endl;
    DisplayContents(vecIntegers);

    return 0;
}
