#include <map>
#include <algorithm>
#include <string>
#include <iostream>
using namespace std;

template <typename T>
void DisplayContents (const T& Input)
{
   for(auto iElement = Input.cbegin() // auto and cbegin(): C++11.
      ; iElement != Input.cend()  // cend() to nowość w C++11.
      ; ++ iElement )
      cout << iElement->first << " -> " << iElement->second << endl;

   cout << endl;
}

struct PredIgnoreCase
{
    bool operator() (const string& str1, const string& str2) const
    {
        string str1NoCase (str1), str2NoCase (str2);
        std::transform (str1.begin(), str1.end(), str1NoCase.begin(), tolower);
        std::transform (str2.begin(), str2.end(), str2NoCase.begin(), tolower);

        return (str1NoCase < str2NoCase);
    };
};

typedef map <string, string> DIRECTORY_WITHCASE;
typedef map <string, string, PredIgnoreCase> DIRECTORY_NOCASE;

int main ()
{
    // Nierozróżniająca wielkości znaków książka telefoniczna: wielkość znaków ciągu tekstowego nie ma znaczenia.
    DIRECTORY_NOCASE dirCaseInsensitive;

    dirCaseInsensitive.insert(make_pair("Jan", "2345764"));
    dirCaseInsensitive.insert(make_pair("JAN", "2345764"));
    dirCaseInsensitive.insert(make_pair("Sandra", "42367236"));
    dirCaseInsensitive.insert(make_pair("Jacek", "32435348"));

    cout << "Wyświetlenie zawartości obiektu map, który nie rozróżnia wielkości znaków:" << endl;
    DisplayContents(dirCaseInsensitive);

    // Wielkość znaków ciągu tekstowego klucza ma wpływ na operacje wstawiania i wyszukiwania.
    DIRECTORY_WITHCASE dirCaseSensitive(dirCaseInsensitive.begin()
       , dirCaseInsensitive.end());

    cout << "Wyświetlenie zawartości obiektu map, który rozróżnia wielkość znaków:" << endl;
    DisplayContents(dirCaseSensitive);

    // Wyszukanie imienia w tych dwóch obiektach map i wyświetlenie wyników operacji.
    cout << "Proszę podać imię do wyszukania: " << endl << "> ";
    string strNameInput;
    cin >> strNameInput;

    // Wyszukiwanie w obiekcie map...
    auto iPairInNoCaseDir = dirCaseInsensitive.find (strNameInput);
    if (iPairInNoCaseDir != dirCaseInsensitive.end())
    {
        cout << "Numer telefonu osoby " <<iPairInNoCaseDir->first<< " w książce telefonicznej,";
        cout << " która nie rozróżnia wielkości znaków to: " << iPairInNoCaseDir->second << endl;
    }
    else
    {
        cout << "Numer telefonu osoby " << strNameInput << " nie został znaleziony";
        cout << "w książce telefonicznej, która nie rozróżnia wielkości znaków" << endl;
    }

    // Wyszukiwanie w obiekcie map, który rozróżnia wielkość znaków...
    auto iPairInCaseSensDir = dirCaseSensitive.find (strNameInput);
    if (iPairInCaseSensDir != dirCaseSensitive.end())
    {
        cout<< "Numer telefonu osoby " << iPairInCaseSensDir->first<< " w książce telefonicznej,";
        cout << " która rozróżnia wielkość znaków to: " << iPairInCaseSensDir->second << endl;
    }
    else
    {
        cout << "Numer telefonu osoby " << strNameInput << " nie został znaleziony";
        cout << " w ksiażce telefonicznej, która rozróżnia wielkość znaków" << endl;
    }

    return 0;
}
