#include <map>
#include <iostream>
#include<string> 

using namespace std;

// Zdefiniowanie typedef dla definicji obiektów map i multimap w celu zwiększenia czytelności.
typedef map <int, string> MAP_INT_STRING;
typedef multimap <int, string> MMAP_INT_STRING;

template <typename T>
void DisplayContents (const T& Input)
{
   for(auto iElement = Input.cbegin() // auto i cbegin(): C++11.
      ; iElement != Input.cend()  // cend() to nowość w C++11.
      ; ++ iElement )
      cout << iElement->first << " -> " << iElement->second << endl;

   cout << endl;
}

int main ()
{
    MAP_INT_STRING mapIntToString;

    // Wstawienie pary klucz—wartość do obiektu map za pomocą  value_type.
    mapIntToString.insert (MAP_INT_STRING::value_type (3, "Trzy"));

    // Wstawienie pary przy użyciu funkcji make_pair.
    mapIntToString.insert (make_pair (-1, "Minus Jeden"));

    // Bezpośrednie wstawienie obiektu pary.
    mapIntToString.insert (pair <int, string> (1000, "Tysiąc"));

    // Wstawienie pary klucz—wartość przy użyciu składni podobnej do tablicy.
    mapIntToString [1000000] = "Milion";

    cout << "Obiekt map zawiera " << mapIntToString.size ();
    cout << " par(ę/y) klucz-wartość. Elementy w obiekcie map to:" << endl;
    DisplayContents(mapIntToString);

   // Utworzenie obiektu multimap, który jest kopią obiektu map.
   MMAP_INT_STRING mmapIntToString(mapIntToString.cbegin(),
                           mapIntToString.cend());

    // W obiekcie multimap funkcja insert() działa dokładnie w taki sam sposób.
    // Obiekt multimap może przechowywać duplikaty — wstawiamy jeden.
    mmapIntToString.insert (make_pair (1000, "Tysiąc"));

    cout << endl << "Obiekt multimap zawiera " << mmapIntToString.size ();
    cout << " par(ę/y) klucz-wartość." << endl;
    cout << "Elementy w obiekcie multimap to: " << endl;
    DisplayContents(mmapIntToString);

    // Obiekt multimap może również podać liczbę par o tym samym kluczu.
    cout << "Liczba par w obiekcie multimap o kluczu 1000: "
        << mmapIntToString.count (1000) << endl;

    return 0;
}
