#include <deque>
#include <iostream>
#include <algorithm>

int main ()
{
    using namespace std;

    // Zdefiniowanie liczb całkowitych obiektu deque.
    deque <int> dqIntegers;

    // Wstawienie liczb całkowitych na końcu tablicy.
    dqIntegers.push_back (3);
    dqIntegers.push_back (4);
    dqIntegers.push_back (5);

    // Wstawienie liczb całkowitych na początku tablicy.
    dqIntegers.push_front (2);
    dqIntegers.push_front (1);
    dqIntegers.push_front (0);

    cout << "Zawartość obiektu deque po wstawieniu elementów ";
    cout << "na początku i na końcu to:" << endl;

    // Wyświetlenie na ekranie zawartości obiektu.
    for ( size_t nCount = 0
        ; nCount < dqIntegers.size ()
        ; ++ nCount )
    {
        cout << "Element [" << nCount << "] = ";
        cout << dqIntegers [nCount] << endl;
    }

    cout << endl;

    // Usunięcie elementu z początku tablicy.
    dqIntegers.pop_front ();

    // Usunięcie elementu z końca tablicy.
    dqIntegers.pop_back ();

    cout << "Zawartość obiektu deque po usunięciu elementów";
    cout << "z początku i końca obiektu to:" << endl;

    // Ponowne wyświetlenie zawartości obiektu, tym razem za pomocą iteratorów.
    // Jeśli używasz starszego kompilatora, usuń słowo auto i znak komentarza w kolejnym wierszu.
    // deque <int>::iterator iElementLocator;
    for (auto iElementLocator = dqIntegers.begin ()
        ; iElementLocator != dqIntegers.end ()
        ; ++ iElementLocator )
    {
        size_t Offset = distance (dqIntegers.begin (), iElementLocator);
        cout<< "Element [" << Offset << "] = " << *iElementLocator << endl;
    }

    return 0;
}
