#include <iostream>
using namespace std;

class MyString
{
private:
   char* Buffer;

   // Domyślny konstruktor prywatny.
   MyString(): Buffer(NULL)
   {
      cout << "Wywołany został konstruktor domyślny" << endl;
   }

public:
   // Destruktor.
   ~MyString()
   {
      if (Buffer != NULL)
         delete [] Buffer;
   }

   int GetLength()
   {
      return strlen(Buffer);
   }

   operator const char*()
   {
      return Buffer;
   }

   MyString operator+ (const MyString& AddThis)
   {
      cout << "Wywołany został operator +: " << endl;
      MyString NewString;

      if (AddThis.Buffer != NULL)
      {
         NewString.Buffer = new char[GetLength() + strlen(AddThis.Buffer) + 1];
         strcpy(NewString.Buffer, Buffer);
         strcat(NewString.Buffer, AddThis.Buffer);
      }

      return NewString;
   }

   // Konstruktor.
   MyString(const char* InitialInput)
   {
      cout << "Wywołany został konstruktor dla: " << InitialInput << endl;
      if(InitialInput != NULL)
      {
         Buffer = new char [strlen(InitialInput) + 1];
         strcpy(Buffer, InitialInput);
      }
      else
         Buffer = NULL;
   }

   // Konstruktor kopiujący.
   MyString(const MyString& CopySource)
   {
      cout<<"Konstruktor kopiujący w celu kopiowania z: "<<CopySource.Buffer<<endl;
      if(CopySource.Buffer != NULL)
      {
         // Zapewnienie utworzenia głębokiej kopii przez alokację własnego bufora w pierwszej kolejności.
         Buffer = new char [strlen(CopySource.Buffer) + 1];

         // Operacja kopiowania źródła do bufora lokalnego.
         strcpy(Buffer, CopySource.Buffer);
      }
      else
         Buffer = NULL;
   }

   // Kopiujący operator przypisania.
   MyString& operator= (const MyString& CopySource)
   {
      cout<<"Kopiujący operator przypisania w celu kopiowania z: "<<CopySource.Buffer<< endl;
      if ((this != &CopySource) && (CopySource.Buffer != NULL))
      {
         if (Buffer != NULL)
          delete[] Buffer;

         // Zapewnienie utworzenia głębokiej kopii przez alokację własnego bufora w pierwszej kolejności.
         Buffer = new char [strlen(CopySource.Buffer) + 1];

         // Operacja kopiowania źródła do bufora lokalnego.
         strcpy(Buffer, CopySource.Buffer);
      }

     return *this;
   }

   // Konstruktor przenoszący.
   MyString(MyString&& MoveSource)
   {
      cout << "Konstruktor przenoszący w celu przeniesienia z: " << MoveSource.Buffer << endl;
      if(MoveSource.Buffer != NULL)
      {
         Buffer = MoveSource.Buffer; // Przejęcie własności.
         MoveSource.Buffer = NULL;   // Zwolnienie zasobów.
      }
    }

   // Przenoszący operator przypisania.
   MyString& operator= (MyString&& MoveSource)
   {
     cout<<"Przenoszący operator przypisania w celu przeniesienia z: "<<MoveSource.Buffer<<endl;
     if((MoveSource.Buffer != NULL) && (this != &MoveSource))
     {
        delete Buffer; // Zwolnienie pamięci zajmowanej przez bufor.

        Buffer = MoveSource.Buffer; // Przejęcie własności.
        MoveSource.Buffer = NULL;   // Zwolnienie zasobów.
     }

     return *this;
  }
};

int main()
{
   MyString Hello("Witaj, ");
   MyString World("świecie");
   MyString CPP(" języka C++");

   MyString sayHelloAgain ("nadpisz to");
   sayHelloAgain = Hello + World + CPP;

   return 0;
}
