#include<unordered_set>
#include <iostream>
using namespace std;

template <typename T>
void DisplayContents(const T& Input)
{
   cout << "Liczba elementów, size() = " << Input.size() << endl;
   cout << "Maksymalna liczba kubełków = " << Input.max_bucket_count() << endl;
   cout << "Współczynnik wypełniania: " << Input.load_factor() << endl;
   cout << "Maksymalny współczynnik wypełniania = " << Input.max_load_factor() << endl;
   cout << "Zawartość nieposortowanego obiektu: " << endl;

   for(auto iElement = Input.cbegin() // auto, cbegin: C++11.
      ; iElement != Input.cend()  // cend() to nowość w C++11.
      ; ++ iElement )
      cout<< *iElement << ' ';

   cout<< endl;
}

int main()
{
   // Utworzenie obiektu unordered_set typu int:
   unordered_set<int> usetInt;

   usetInt.insert(1000);
   usetInt.insert(-3);
   usetInt.insert(2011);
   usetInt.insert(300);
   usetInt.insert(-1000);
   usetInt.insert(989);
   usetInt.insert(-300);
   usetInt.insert(111);
   DisplayContents(usetInt);
   usetInt.insert(999);
   DisplayContents(usetInt);

   // Metoda find():
   cout << "Podaj liczbę, której istnienie chcesz sprawdzić w kolekcji: ";
   int Key = 0;
   cin >> Key;
   auto iPairThousand = usetInt.find(Key);

   if (iPairThousand != usetInt.end())
      cout << *iPairThousand << " znaleziono w kolekcji" << endl;
   else
      cout << Key << " nie znaleziono w kolekcji" << endl;

   return 0;
}
