template <typename T>
class destructivecopy_pointer
{
private:
    T* pObject;
public:
    destructivecopy_pointer(T* pInput):pObject(pInput) {}
    ~destructivecopy_pointer() { delete pObject; }

    // Konstruktor kopiujący.
    destructivecopy_pointer(destructivecopy_pointer& source)
    {
        // Przeniesienie praw własności na kopię.
        pObject = source.pObject;

        // Usunięcie źródła.
        source.pObject = 0;
    }

    // Kopiujący operator przypisania.
    destructivecopy_pointer& operator= (destructivecopy_pointer& rhs)
    {
        if (pObject != source.pObject)
        {
            delete pObject;
            pObject = source.pObject;
           source.pObject = 0;
       }
    }
};

int main()
{
   destructivecopy_pointer<int> pNumber (new int);
   destructivecopy_pointer<int> pCopy = pNumber;

   // Wskaźnik pNumber jest teraz nieprawidłowy.
   return 0;
}
