#include <algorithm>
#include <iostream>
#include <vector>
#include <string>
using namespace std;

// Typ obiektu funkcji jednoargumentowej wywoływanej przez algorytm for_each.
template <typename elementType>
struct DisplayElementKeepCount
{
    int Count;

    // Konstruktor.
    DisplayElementKeepCount (): Count (0) {}

    void operator () (const elementType& element) 
    {
        ++ Count;
        cout << element << ' ';
    }
};

int main ()
{
    vector <int> vecIntegers;
    for (int nCount = 0; nCount < 10; ++ nCount)
        vecIntegers.push_back (nCount);

    cout << "Wyświetlenie obiektu vector przechowującego liczby całkowite: " << endl;

    // Wyświetlenie tablicy liczb całkowitych.
    DisplayElementKeepCount<int> Functor =
        for_each ( vecIntegers.begin ()   // Początek zakresu.
                 , vecIntegers.end ()        // Koniec zakresu.
                 , DisplayElementKeepCount<int> () ); // Funktor.
    cout << endl;

    // Użycie informacji o stanie przechowywanej wartości zwracanej przez algorytm for_each!
    cout << "W obiekcie vector wyświetlono '" << Functor.Count << "' elementów!" << endl;

    string Sample ("algorytm for_each i ciągi tekstowe!");
    cout << "Przykładowy ciąg tekstowy to: " << Sample << ", długość: " << Sample.length() << endl;

    cout << "Ciąg tekstowy wyświetlony za pomocą wyrażenia lambda:" << endl;
   int NumChars = 0;
   for_each ( Sample.begin()
            , Sample.end ()
            , [&NumChars](char c) { cout << c << ' '; ++NumChars; } );

    cout << endl; 
    cout << "Wyświetlono '" << NumChars << "' znaków" << endl;

    return 0;
}
