#include <algorithm>
#include <vector>
#include <iostream>
using namespace std;

bool IsEven (const int& nNumber)
{
    return ((nNumber % 2) == 0);
}

template <typename T>
void DisplayContents (const T& Input)
{
   for(auto iElement = Input.cbegin() // auto i cbegin(): C++11.
      ; iElement != Input.cend() // cend() to nowość w C++11.
      ; ++ iElement )
      cout << *iElement << ' ';

   cout << " | Liczba elementów: " << Input.size() << endl;
}
int main ()
{
    vector <int> vecIntegers;

    for (int nNum = 0; nNum < 10; ++ nNum)
        vecIntegers.push_back (nNum);

    cout << "Zawartość początkowa: " << endl;
    DisplayContents(vecIntegers);

    vector <int> vecCopy (vecIntegers);

    cout << "Zawartość obiektu vector po użyciu algorytmu 'partition' jest następująca:" << endl;
    partition (vecIntegers.begin (), vecIntegers.end (), IsEven);
    DisplayContents(vecIntegers);

    cout << "Efekt użycia algorytmu 'stable_partition' jest następujący: " << endl;
    stable_partition (vecCopy.begin (), vecCopy.end (), IsEven);
    DisplayContents(vecIntegers);
    return 0;
}
