#include <list>
#include <iostream>
using namespace std;

template <typename T>
void DisplayContents(const T& Input)
{
    for (auto iElement = Input.cbegin() // auto i cbegin() dla C++11.
        ; iElement != Input.cend()
        ; ++ iElement )
       cout << *iElement << ' '; 

    cout << endl;
}

int main ()
{
    std::list <int> listIntegers;

    // Wstawianie elementów na początku i końcu.
    listIntegers.push_front (4);
    listIntegers.push_front (3);
    listIntegers.push_front (2);
    listIntegers.push_front (1);
    listIntegers.push_front (0);
    listIntegers.push_back (5);

    cout << "Początkowa zawartość obiektu list:" << endl;
    DisplayContents(listIntegers);

    listIntegers.reverse ();

    cout << "Zawartość obiektu list po użyciu funkcji reverse():" << endl;
    DisplayContents(listIntegers);

    return 0; 
}
