#include <algorithm>
#include <iostream>
#include <vector>
#include <string>

using namespace std;

// Typ obiektu funkcji jednoargumentowej wywoywanej przez algorytm for_each
template <typename elementType>
class DisplayElementKeepCount
{
  private:
    int m_nCount;

  public:
    DisplayElementKeepCount ()
    {
        m_nCount = 0;
    }

    void operator () (const elementType& element) 
    {
        ++ m_nCount;
        cout << element << ' ';
    }

    int GetCount ()
    {
        return m_nCount;
    }
};

int main ()
{
    vector <int> vecIntegers;

    for (int nCount = 0; nCount < 10; ++ nCount)
        vecIntegers.push_back (nCount);

    cout << "Wyswietlenie obiektu vector przechowujacego liczby calkowite: " << endl;

    // Wywietlenie tablicy liczb cakowitych
    DisplayElementKeepCount<int> mIntResult =
        for_each ( vecIntegers.begin ()   // Pocztek zakresu
                 , vecIntegers.end ()        // Koniec zakresu
                 , DisplayElementKeepCount<int> () );// Funktor

    cout << endl;

    // Uycie informacji o stanie przechowywanej w wartoci zwracanej przez algorytm for_each!
    cout << "W obiekcie vector wyswietlono '" << mIntResult.GetCount () << "'";
    cout << " elementow!" << endl << endl;

    string strSample ("algorytm for_each i ciagi tekstowe!");
    cout << "Przykladowy ciag tekstowy to: " << strSample << endl << endl;

    cout << "Ciag tekstowy wyswietlony za pomoca DisplayElementKeepCount:" << endl;
    DisplayElementKeepCount<char> mCharResult = for_each (strSample.begin()
                        , strSample.end ()
                        , DisplayElementKeepCount<char> () );
    cout << endl; 

    cout << "Wyswietlono '" << mCharResult.GetCount () << "' znakow";

    return 0;
}
