#include <algorithm>
#include <iostream>
#include <vector>
#include <list>

using namespace std;

// Struktura, ktra zachowuje si jak funkcja jednoargumentowa
template <typename elementType>
struct DisplayElement
{
    void operator () (const elementType& element) const
    {
        cout << element << ' ';
    }
};

int main ()
{
    vector <int> vecIntegers;

    for (int nCount = 0; nCount < 10; ++ nCount)
        vecIntegers.push_back (nCount);

    list <char> listChars;

    for (char nChar = 'a'; nChar < 'k'; ++nChar)
        listChars.push_back (nChar);

    cout << "Wyswietlanie obiektu vector przechowujacego liczby calkowite: " << endl;

    // Wywietlanie tablicy liczb cakowitych
    for_each ( vecIntegers.begin ()    // Pocztek zakresu
          , vecIntegers.end ()        // Koniec zakresu
          , DisplayElement <int> () ); // Obiekt funkcji jednoargumentowej

    cout << endl << endl;
    cout << "Wyswietlanie obiektu list przechowujacego znaki: " << endl;

    // Wywietlenie znakw
    for_each ( listChars.begin ()        // Pocztek zakresu
          , listChars.end ()        // Koniec zakresu
          , DisplayElement <char> () );// Obiekt funkcji jednoargumentowej

    return 0;
}
