#include <map>
#include <iostream>
#include <string>

using namespace std;

// Zdefiniowanie typedef dla definicji obiektu  multimap w celu zwikszenia czytelnoci
typedef multimap <int, string> MMAP_INT_STRING;

int main ()
{
    MMAP_INT_STRING mmapIntToString;

    // W obiekcie multimap funkcja insert() dziaa w taki sam sposb
    mmapIntToString.insert (MMAP_INT_STRING::value_type (3, "Trzy"));
    mmapIntToString.insert (MMAP_INT_STRING::value_type (45, "Czterdziesci piec"));
    mmapIntToString.insert (MMAP_INT_STRING::value_type (-1, "Minus Jeden"));
    mmapIntToString.insert (MMAP_INT_STRING::value_type (1000, "Tysiac"));

    // Obiekt multimap moe przechowywa duplikaty  wstawiamy jeden
    mmapIntToString.insert (MMAP_INT_STRING::value_type 
                            (1000, "Tysiac (duplikat)"));

    cout << "Obiekt multimap zawiera " << mmapIntToString.size ();
    cout << " par(y) klucz-wartosc." << endl;
    cout << "Elementy w obiekcie multimap to: " << endl;

    // Wywietlenie na ekranie zawartoci obiektu multimap
    MMAP_INT_STRING::const_iterator iMultiMapPairLocator; 

    for ( iMultiMapPairLocator = mmapIntToString.begin ()
        ; iMultiMapPairLocator != mmapIntToString.end ()
        ; ++ iMultiMapPairLocator )
    {
        cout << "Klucz: " << iMultiMapPairLocator->first;
        cout << ", Wartosc: " << iMultiMapPairLocator->second << endl;
    }

    cout << endl;

    cout << "Wyszukiwanie wszystkich par klucz-wartosc z kluczem '1000': " << endl;

    // Wyszukanie elementu w obiekcie multimap za pomoc funkcji find()
    MMAP_INT_STRING::const_iterator iElementFound;
    
    iElementFound = mmapIntToString.find (1000);

    // Sprawdzenie, czy dziaanie funkcji find() zakoczyo si powodzeniem
    if (iElementFound != mmapIntToString.end ())
    {
        // Okrelenie liczby par, ktre maj ten sam (podany) klucz
        size_t nNumPairsInMap = mmapIntToString.count (1000);
        cout << " Liczba par w obiektcie multimap wraz z kluczem 1000: ";
        cout << nNumPairsInMap << endl;

        // Wywietlenie tych wartoci na ekranie
        cout << "Wartosci odpowiadajace kluczowi 1000 to: " << endl;
        for ( size_t nValuesCounter = 0
            ; nValuesCounter < nNumPairsInMap
            ; ++ nValuesCounter )
        {
            cout << "Klucz: " << iElementFound->first;
            cout << ", Wartosc [" << nValuesCounter << "] = ";
            cout << iElementFound->second << endl;

            ++ iElementFound;
        }
    }
    else
        cout << "Element nie zostal znaleziony w obiekcie multimap";

    return 0;
}
