#include <iostream>
using namespace std;

// Abstrakcyjny typ danych wyjtku
class Exception
{
   public:
      Exception(){}
      virtual ~Exception(){}
      virtual void PrintError() = 0;
};

// Problemy zwizane z pamici obsuguje klasa pochodna.
// Zwr uwag na alokacj pamici w tej klasie!
class OutOfMemory : public Exception
{
   public:
      OutOfMemory(){}
      ~OutOfMemory(){}
      virtual void PrintError();
   private:
};

void OutOfMemory::PrintError()
{
   cout << "Brak pamieci!!" << endl;
}

// Nieprawidowe liczby s obsugiwane przez klas pochodn
class RangeError : public Exception
{
   public:
      RangeError(unsigned long number){badNumber = number;}
      ~RangeError(){}
      virtual void PrintError();
      virtual unsigned long GetNumber() { return badNumber; }
      virtual void SetNumber(unsigned long number) {badNumber = number;}
   private:
      unsigned long badNumber;
};

void RangeError::PrintError()
{
   cout << "Liczba spoza zakresu. Uzyles liczby " ;
   cout << GetNumber() << "!!" << endl;
}

void MyFunction();  // Prototyp funkcji

int main()
{
   try
   {
      MyFunction();
   }
   // Wymagana jest tylko jedna instrukcja catch, waciwe operacje
   // s wykonywane przez funkcje wirtualne.
   catch (Exception& theException)
   {
      theException.PrintError();
   }
   return 0;
}

void MyFunction()
{
   unsigned int *myInt = new unsigned int;
   long testNumber;

   if (myInt == 0)
      throw OutOfMemory();

   cout << "Podaj liczbe typu int: ";
   cin >> testNumber;

   // Ten dziwny test powinien zosta zastpiony seri testw
   // wywietlajcych informacje o bdnych danych wejciowych podanych przez uytkownika

   if (testNumber > 3768 || testNumber < 0)
      throw RangeError(testNumber);

   *myInt = testNumber;
   cout << "Ok. myInt: " << *myInt;
   delete myInt;
}
