#include <iostream>
#include <algorithm>
#include <vector>

// Predykat jednoargumentowy uywany przez funkcj replace_if() w celu zastpowania liczb parzystych
bool IsEven (const int & nNum)
{
    return ((nNum % 2) == 0);
}

int main ()
{
    using namespace std;

    // Inicjalizacja przykadowego obiektu vector wraz z szecioma elementami
    vector <int> vecIntegers (6);

    // Wypenienie pierwszych trzech elementw wartoci 8
    fill (vecIntegers.begin (), vecIntegers.begin () + 3, 8);

    // Wypenienie trzech ostatnich elementw wartoci 5
    fill_n (vecIntegers.begin () + 3, 3, 5);

    // Umieszczenie elementw kontenera w losowej kolejnoci
    random_shuffle (vecIntegers.begin (), vecIntegers.end ());
    
    cout << "Poczatkowa zawartosc obiektu vector jest nastepujaca: " << endl;
    for (size_t nIndex = 0; nIndex < vecIntegers.size (); ++ nIndex)
    {
        cout << "Element [" << nIndex << "] = ";
        cout << vecIntegers [nIndex] << endl;
    }

    cout << endl << "Uzycie funkcji 'std::replace' w celu zastapienia wartosci 5 przez wartosc 8" << endl;
    replace (vecIntegers.begin (), vecIntegers.end (), 5, 8);

    cout << "Uzycie funkcji 'std::replace_if' w celu zastapienia liczb parzystych przez wartosc -1" << endl;
    replace_if (vecIntegers.begin (), vecIntegers.end (), IsEven, -1);

    cout << endl << "Zawartosc obiektu vector po operacjach zastepowania:" << endl;
    for (size_t nIndex = 0; nIndex < vecIntegers.size (); ++ nIndex)
    {
        cout << "Element [" << nIndex << "] = ";
        cout << vecIntegers [nIndex] << endl;
    }

    return 0;
}
