#include <algorithm>
#include <vector>
#include <list>
#include <iostream>

// Predykat jednoargumentowy dla funkcji remove_if()
template <typename elementType>
bool IsOdd (const elementType& number)
{
    // Zwraca warto true, jeeli liczba jest nieparzysta
    return ((number % 2) == 1);
}

int main ()
{
    using namespace std;

    // Obiekt list wraz z przykadowymi wartociami
    list <int> listIntegers;

    for (int nCount = 0; nCount < 10; ++ nCount)
        listIntegers.push_back (nCount);

    cout << "Elementy w obiekcie zrodlowym (list) sa nastepujace: " << endl;

    // Wywietlenie wszystkich elementw kolekcji
    list <int>::const_iterator iElementLocator;
    for ( iElementLocator = listIntegers.begin ()
        ; iElementLocator != listIntegers.end ()
        ; ++ iElementLocator )
        cout << *iElementLocator << ' ';

    cout << endl << endl;

    // Inicjalizacja obiektu vector przeznaczonego do przechowywania dwukrotnie wikszej liczby elementw ni list
    vector <int> vecIntegers (listIntegers.size () * 2);

    vector <int>::iterator iLastPos;
    iLastPos = copy ( listIntegers.begin ()  // pocztek zakresu rdowego
             , listIntegers.end ()      // koniec zakresu rdowego
             , vecIntegers.begin () ); // pocztek zakresu docelowego

    // Teraz za pomoc funkcji copy_backward() kopiujemy zawarto obiektu list do obiektu vector
    copy_backward ( listIntegers.begin ()
                  , listIntegers.end ()
                  , vecIntegers.end () );

    cout << "Elementy w obiekcie docelowym (vector) po operacji kopiowania sa nastepujace: " << endl;

    // Wywietlenie wszystkich elementw kolekcji
    vector <int>::const_iterator iDestElementLocator;
    for ( iDestElementLocator = vecIntegers.begin ()
        ; iDestElementLocator != vecIntegers.end ()
        ; ++ iDestElementLocator )
        cout << *iDestElementLocator << ' ';

    cout << endl << endl; 

    /*
        Usunicie wszystkich wystpie elementu '0':
        funkcja std::remove nie zmienia wielkoci kontenera, 
        ona po prostu przenosi elementy do przodu w celu wypenienia utworzonej przerwy
        i zwraca nowe pooenie 'end'.
    */
    vector <int>::iterator iNewEnd;
    iNewEnd = remove (vecIntegers.begin (), vecIntegers.end (), 0);

    // Uycie tego nowego pooenia 'end'  w celu zmiany wielkoci obiektu vector
    vecIntegers.erase (iNewEnd, vecIntegers.end ());

    // Usunicie z obiektu vector wszystkich liczb nieparzystych za pomoc funkcji remove_if()
    iNewEnd = remove_if (vecIntegers.begin (), vecIntegers.end (), 
                        IsOdd <int>);    // Predykat

    vecIntegers.erase (iNewEnd , vecIntegers.end ());

    cout << "Elementy w obiekcie docelowym (vector) po operacji usuniecia sa nastepujace: " << endl;

    // Wywietlenie wszystkich elementw kolekcji
    for ( iDestElementLocator = vecIntegers.begin ()
        ; iDestElementLocator != vecIntegers.end ()
        ; ++ iDestElementLocator )
        cout << *iDestElementLocator << ' ';
    
    return 0;
}
