#include <algorithm>
#include <list>
#include <string>
#include <iostream>

int main ()
{
    using namespace std;

    typedef list <string> LIST_STRINGS;

    // Przykadowy obiekt list przechowujcy cigi tekstowe
    LIST_STRINGS listNames;

    // Wstawienie wartoci przykadowych
    listNames.push_back ("John Doe");
    listNames.push_back ("Brad Pitt");
    listNames.push_back ("Jack Nicholson");
    listNames.push_back ("Sean Penn");
    listNames.push_back ("Anna Hoover");

    // Posortowanie wszystkich elementw w obiekcie list
    listNames.sort ();

    cout << "Posortowany obiekt list zawiera elementy w nastepujacej kolejnosci: " << endl;
    LIST_STRINGS::iterator iNameLocator;
    for ( iNameLocator = listNames.begin ()
        ; iNameLocator != listNames.end ()
        ; ++ iNameLocator )
    {
        cout << "Element [" << distance (listNames.begin (), iNameLocator);
        cout << "] = \"" << *iNameLocator << "\"" << endl;
    }

    cout << endl;

    LIST_STRINGS::iterator iMinInsertPosition;

    // Najblisze/najnisze pooenie, w ktrym mona umieci element
    iMinInsertPosition = lower_bound ( listNames.begin (), listNames.end ()
                                     , "Brad Pitt" );
    
    LIST_STRINGS::iterator iMaxInsertPosition;

    // Najdalsze/najwysze pooenie, w ktrym mona umieci element
    iMaxInsertPosition = upper_bound ( listNames.begin (), listNames.end ()
                                     , "Brad Pitt" );

    cout << "Najnizsza wartosc indeksu, w ktorym mozna umiescic element \"Brad Pitt\" to: ";
    cout << distance (listNames.begin (), iMinInsertPosition) << endl;

    cout << " Najwyzsza wartosc indeksu, w ktorym mozna umiescic element \"Brad Pitt\" to: ";
    cout << distance (listNames.begin (), iMaxInsertPosition) << endl;

    cout << endl;

    cout << "Wstawianie elementu \"Brad Pitt\" do posortowanego obiektu list:" << endl;
    listNames.insert (iMinInsertPosition, "Brad Pitt");

    cout << "Obiekt list zawiera teraz nastepujace elementy: " << endl;
    for ( iNameLocator = listNames.begin ()
        ; iNameLocator != listNames.end ()
        ; ++ iNameLocator )
    {
        cout << "Element [" << distance (listNames.begin (), iNameLocator);
        cout << "] = \"" << *iNameLocator << "\"" << endl;
    }

    return 0;
}
