#include <set>
#include <iostream>
#include <string>

using namespace std;

enum MenuOptionSelection
{
    InsertContactsetEntry = 0,
    DisplayEntries = 1,
    FindNumber = 2,
    EraseEntry = 3,
    QuitApplication = 4
};

struct ContactItem
{
    string strContactsName;
    string strPhoneNumber;

    // Konstruktor
    ContactItem (const string& strName, const string & strNumber)
    {
        strContactsName = strName; 
        strPhoneNumber = strNumber;
    }

    bool operator == (const ContactItem& itemToCompare) const
    {
        return (itemToCompare.strContactsName == this->strContactsName);
    }

    bool operator < (const ContactItem& itemToCompare) const
    {
        return (this->strContactsName < itemToCompare.strContactsName);
    }
};

int ShowMenu ();
ContactItem GetContactInfo ();
void DisplayContactset (const set <ContactItem>& setContacts);
void FindContact (const set <ContactItem>& setContacts);
void EraseContact (set <ContactItem>& setContacts);

int main ()
{
    set <ContactItem> setContacts;
    int nUserSelection = InsertContactsetEntry;

    while ((nUserSelection = ShowMenu ()) != (int) QuitApplication)
    {
        switch (nUserSelection)
        {
        case InsertContactsetEntry:
            setContacts.insert (GetContactInfo ());
            cout << "Lista kontaktow zostala uaktualniona!" << endl << endl;
            break;

        case DisplayEntries:
            DisplayContactset (setContacts);
            break;

        case FindNumber:
            FindContact (setContacts); 
            break;

        case EraseEntry:
            EraseContact (setContacts);
            DisplayContactset (setContacts);
            break;

        default:
            cout << "Nieprawidlowe dane wejsciowe '" << nUserSelection;
            cout << ".' Wybierz opcje z zakresu od 0 do 4" << endl;
            break;
        }
    }

    cout << "Koniec! Zegnaj!" << endl;
    return 0;
}

void DisplayContactset (const set <ContactItem>& setContacts)
{
    cout << "*** Wyswietlanie informacji kontaktowych ***" << endl;
    cout << "W ksiazce znajduja sie " << setContacts.size () << " wpisy:" << endl;

    set <ContactItem>::const_iterator iContact;
    for ( iContact = setContacts.begin ()
        ; iContact != setContacts.end ()
        ; ++ iContact )
        cout << "Imie: '" << iContact->strContactsName << "' Numer telefonu: '"
        << iContact->strPhoneNumber << "'" << endl;

    cout << endl;
}

ContactItem GetContactInfo ()
{
    cout << "*** Podaj informacje kontaktowe ***" << endl;
    string strName;
    cout << "Prosze podac imie osoby" << endl;; 
    cout << "> ";
    cin >> strName;

    string strPhoneNumber;
    cout << "Prosze podac numer telefonu" << strName << " do osoby " << endl;
    cout << "> ";
    cin >> strPhoneNumber;

    return ContactItem (strName, strPhoneNumber);
}

int ShowMenu ()
{
    cout << "***Co chcialbys teraz zrobic? ***" << endl << endl;
    cout << "Wybierz 0, aby podac imie i numer telefonu" << endl;
    cout << "Wybierz 1, aby wyswietlic wszystkie wpisy" << endl;
    cout << "Wybierz 2, aby znalezc wpis" << endl;
    cout << "Wybierz 3, aby usunac wpis" << endl;
    cout << "Wybierz 4, aby zakonczyc prace aplikacji" << endl << endl;
    cout << "> ";

    int nOptionSelected = 0;

    // Akceptacja danych wejciowych uytkownika
    cin >> nOptionSelected ;
    cout << endl;
    return nOptionSelected;
}

void FindContact (const set <ContactItem>& setContacts)
{
    cout << "*** Wyszukanie danych kontaktowych ***" << endl;
    cout << "Czyj numer telefonu chcialbys znalezc?" << endl;
    cout << "> ";
    string strName;
    cin >> strName;

    set <ContactItem>::const_iterator iContactFound
        = setContacts.find (ContactItem (strName, ""));

    if (iContactFound != setContacts.end ())
    {
        cout << strName << " jest dostepny pod numerem telefonu: ";
        cout << iContactFound->strPhoneNumber << endl;
    }
    else
        cout << strName << " nie zostal znaleziony na liscie kontaktow" << endl;

    cout << endl;

    return;
}

void EraseContact (set <ContactItem>& setContacts) 
{
    cout << "*** Usuniecie kontaktu ***" << endl;
    cout << "Czyj numer telefonu chcialbys usunac?" << endl;
    cout << "> ";
    string strName;
    cin >> strName;

    size_t nErased = setContacts.erase (ContactItem (strName, ));
    if (nErased > 0)
        cout << "Usunieto informacje kontaktowe osoby " << strName << endl;
    else
        cout << "Nie znaleziono osoby " << strName << "!" << endl;

    cout << endl;
}
