#include <list>
#include <iostream>

using namespace std;

void PrintListContents (const list <int>& listInput);
bool SortPredicate_Descending (const int& lsh, const int& rsh);

int main ()
{
    std::list <int> listIntegers;

    // Wstawianie elementw na pocztku...
    listIntegers.push_front (444);
    listIntegers.push_front (300);
    listIntegers.push_front (21111);

    listIntegers.push_front (-1);
    listIntegers.push_front (0);

    // Wstawianie elementu na kocu...
    listIntegers.push_back (-5);

    cout << "Poczatkowa zawartosc obiektu list -" << endl;
    PrintListContents (listIntegers);

    listIntegers.sort ();

    cout << "Kolejnosc elementow po uzyciu funkcji sort():" << endl;
    PrintListContents (listIntegers);

    listIntegers.sort (SortPredicate_Descending);
    cout << "Kolejnosc elementow po uzyciu funkcji sort() z predykatem:" << endl;

    PrintListContents (listIntegers);

    return 0;
}

void PrintListContents (const list <int>& listInput) 
{
    if (listInput.size () > 0)
    {
        // Wywietlenie wartoci na ekranie...
        cout << "{ ";

        std::list <int>::const_iterator iElementLocator;
        for ( iElementLocator = listInput.begin ()
            ; iElementLocator != listInput.end ()
            ; ++ iElementLocator )
            cout << *iElementLocator << " ";

        cout << "}" << endl << endl;
    }
    else
        cout << "Obiekt list jest pusty!" << endl;
}

bool SortPredicate_Descending (const int& lsh, const int& rsh)
{
    return (rsh < lsh);
}
