#include <list>
#include <iostream>

using namespace std;

void PrintListContents (const list <int>& listInput);

int main ()
{
    list <int> listIntegers1;

    // Wstawianie elementw na pocztku...
    listIntegers1.insert (listIntegers1.begin (), 4);
    listIntegers1.insert (listIntegers1.begin (), 3);
    listIntegers1.insert (listIntegers1.begin (), 2);
    listIntegers1.insert (listIntegers1.begin (), 1);

    // Wstawianie elementw na kocu...
    listIntegers1.insert (listIntegers1.end (), 5);

    cout << "Zawartosc obiektu list1 po wstawieniu elementow: " << endl;
    PrintListContents (listIntegers1);

    list <int> listIntegers2;

    // Wstawienie czterech elementw wraz z t sam wartoci 0...
    listIntegers2.insert (listIntegers2.begin (), 4, 0);

    cout << "Zawartosc obiektu list2 po wstawieniu '";
    cout << listIntegers2.size () << "' elementow o wartosci:" << endl;
    PrintListContents (listIntegers2);

    list <int> listIntegers3;

    // Wstawienie na pocztku elementw pochodzcych z innego obiektu list...
    listIntegers3.insert (listIntegers3.begin (), 
                          listIntegers1.begin (), listIntegers1.end ());

    cout << "Zawartosc obiektu list3 po wstawieniu na poczatku ";
    cout << "zawartosci obiektu list1:" << endl;
    PrintListContents (listIntegers3);

    // Wstawienie na kocu elementw pochodzcych z innego obiektu list... 
    listIntegers3.insert (listIntegers3.end (), 
                        listIntegers2.begin (), listIntegers2.end ());

    cout << "Zawartosc obiektu list3 po wstawieniu na poczatku ";
    cout << "zawartosci obiektu list2:" << endl;
    PrintListContents (listIntegers3);

    return 0;
}

void PrintListContents (const list <int>& listInput)
{
    // Wywietlenie wartoci na ekranie...
    cout << "{ ";

    std::list <int>::const_iterator iElementLocator;
    for ( iElementLocator = listInput.begin ()
        ; iElementLocator != listInput.end ()
        ; ++ iElementLocator )
        cout << *iElementLocator << " ";

    cout << "}" << endl << endl;
}
