#include <iostream>
using namespace std;
class CAnimal
{
public:
    virtual void Speak () = 0;
};

class CDog : public CAnimal
{
  public:
    void WagTail () {cout << "Pies: Pomachalem ogonem!" << endl;}

    void Speak () {cout << "Pies: Hau-Hau!" << endl;}
};

class CCat : public CAnimal
{
  public:
    void CatchMice () {cout << "Kot: Zlapalem mysz!" << endl;}

    void Speak () {cout << "Kot: Miau!" << endl;}
};

void DetermineType (CAnimal* pAnimal);

int main ()
{
   // pAnimal1 wskazuje obiekt Dog
    CAnimal* pAnimal1 = new CDog ();

    // pAnimal2 wskazuje obiekt Cat
    CAnimal* pAnimal2 = new CCat ();

    cout << "Uzycie dynamic_cast w celu okreslenia typu Animal1" << endl;
    DetermineType (pAnimal1);

    cout << "Uzycie dynamic_cast w celu okreslenia typu Animal2" << endl;
    DetermineType (pAnimal2);

    // Uycie funkcji wirtualnej przesonitej przez podklas, aby udowodni typ
    cout << "Weryfikacja typu: niech Animal1 przemowi!" << endl;
    pAnimal1->Speak ();

    cout << "Weryfikacja typu: niech Animal2 przemowi!" << endl; 
    pAnimal2->Speak ();

    return 0;
}

void DetermineType (CAnimal* pAnimal)
{
    CDog* pDog = dynamic_cast <CDog*>(pAnimal);
   if (pDog)
   {
       cout << "Zwierze to pies!" << endl;

       // Wywoanie funkcji klasy pochodnej
       pDog->WagTail ();
   }

   CCat* pCat = dynamic_cast <CCat*>(pAnimal);
   if (pCat)
   {
       cout << "Zwierze to kot!" << endl;

       pCat->CatchMice ();
   }
}
