// Listing 12.10
// Wyprowadzanie klas abstrakcyjnych z innych klas abstrakcyjnych
#include <iostream>
using namespace std;

enum COLOR { Red, Green, Blue, Yellow, White, Black, Brown } ;

class Animal // wsplna klasa bazowa dla klas Mammal i Fish
{
  public:
    Animal(int);
    virtual ~Animal() { cout << "Destruktor klasy Animal...\n"; }
    virtual int GetAge() const { return itsAge; }
    virtual void SetAge(int age) { itsAge = age; }
    virtual void Sleep() const = 0;
    virtual void Eat() const = 0;
    virtual void Reproduce() const = 0;
    virtual void Move() const = 0;
    virtual void Speak() const = 0;
  private:
   int itsAge;
};

Animal::Animal(int age):
itsAge(age)
{
   cout << "Konstruktor klasy Animal...\n";
}

class Mammal : public Animal
{
  public:
    Mammal(int age):Animal(age)
      { cout << "Konstruktor klasy Mammal...\n";}
    virtual ~Mammal() { cout << "Destruktor klasy Mammal...\n";}
    virtual void Reproduce() const
      { cout << "Rozmnazanie dla klasy Mammal...\n"; }
};

class Fish : public Animal
{
  public:
    Fish(int age):Animal(age)
      { cout << "Konstruktor klasy Fish...\n";}
    virtual ~Fish() {cout << "Destruktor klasy Fish...\n";  }
    virtual void Sleep() const { cout << "Ryba spi...\n"; }
    virtual void Eat() const { cout << "Ryba zeruje...\n"; }
    virtual void Reproduce() const
      { cout << "Ryba sklada jaja...\n"; }
    virtual void Move() const
      { cout << "Ryba plywa...\n";   }
    virtual void Speak() const { }
};

class Horse : public Mammal
{
  public:
    Horse(int age, COLOR color ):
    Mammal(age), itsColor(color)
      { cout << "Konstruktor klasy Horse...\n"; }
    virtual ~Horse() { cout << "Destruktor klasy Horse...\n"; }
    virtual void Speak()const { cout << "Ihaaa!... \n"; }
    virtual COLOR GetItsColor() const { return itsColor; }
    virtual void Sleep() const
      { cout << "Kon spi...\n"; }
    virtual void Eat() const { cout << "Kon sie pasie...\n"; }
    virtual void Move() const { cout << "Kon biegnie...\n";}

  protected:
    COLOR itsColor;
};

class Dog : public Mammal
{
  public:
    Dog(int age, COLOR color ):
    Mammal(age), itsColor(color)
      { cout << "Konstruktor klasy Dog...\n"; }
    virtual ~Dog() { cout << "Destruktor klasy Dog...\n"; }
    virtual void Speak()const { cout << "Hau, hau!... \n"; }
    virtual void Sleep() const { cout << "Pies chrapie...\n"; }
    virtual void Eat() const { cout << "Pies je...\n"; }
    virtual void Move() const  { cout << "Pies biegnie...\n"; }
    virtual void Reproduce() const
      { cout << "Pies sie rozmnaza...\n"; }

  protected:
    COLOR itsColor;
};

int main()
{
   Animal *pAnimal=0;
   int choice;
   bool fQuit = false;

   while (fQuit == false)
   {
      cout << "(1)Dog (2)Horse (3)Fish (0)Quit: ";
      cin >> choice;

      switch (choice)
      {
         case 1: pAnimal = new Dog(5,Brown);
            break;
         case 2: pAnimal = new Horse(4,Black);
            break;
         case 3: pAnimal = new Fish(5);
            break;
         default: fQuit = true;
            break;
      }
      if (fQuit == false)
      {
         pAnimal->Speak();
         pAnimal->Eat();
         pAnimal->Reproduce();
         pAnimal->Move();
         pAnimal->Sleep();
         delete pAnimal;
         cout << endl;
      }
   }
   return 0;
}
