// Listing 9.9 - Przekazywanie wskanikw do obiektw

#include <iostream>

using namespace std;
class SimpleCat
{
    public:
        SimpleCat ();              // konstruktor
        SimpleCat(SimpleCat&);     // konstruktor kopiujcy
        ~SimpleCat();              // destruktor
};

SimpleCat::SimpleCat()
{
    cout << "Konstruktor klasy SimpleCat..." << endl;
}

SimpleCat::SimpleCat(SimpleCat&)
{
    cout << "Konstruktor kopiujcy klasy SimpleCat..." << endl;
}

SimpleCat::~SimpleCat()
{
    cout << "Destruktor klasy SimpleCat..." << endl;
}

SimpleCat FunctionOne (SimpleCat theCat);
SimpleCat* FunctionTwo (SimpleCat *theCat);

int main()
{
    cout << "Tworze obiekt..." << endl;
    SimpleCat Mruczek;
    cout << "Wywoluje funkcje FunctionOne..." << endl;
    FunctionOne(Mruczek);
    cout << "Wywoluje funkcje FunctionTwo..." << endl;
    FunctionTwo(&Mruczek);
    return 0;
}

// FunctionOne, parametr przekazywany poprzez warto
SimpleCat FunctionOne(SimpleCat theCat)
{
    cout << "FunctionOne. Wracam..." << endl;
    return theCat;
}

// FunctionTwo, parametr przekazywany poprzez wskanik
SimpleCat* FunctionTwo (SimpleCat  *theCat)
{
    cout << "FunctionTwo. Wracam..." << endl;
    return theCat;
}
