// DziedziczenieWirtualne — demonstruje dziedziczenie wirtualne.
// Klasy Lozko i Sofa mogą współdzielić klasę bazową
//
#include <cstdio>
#include <cstdlib>
#include <iostream>
using namespace std;
// Mebel — bardziej fundamentalna koncepcja;
// ta klasa posiada składową waga
class Mebel
{
  public:
    Mebel(int w) : waga(w) {}
    int waga;
};
class Lozko : virtual public Mebel
{
  public:
    Lozko(int w = 0) : Mebel(w) {}
    void spij(){ cout << "Spij" << endl; }
};
class Sofa : virtual public Mebel
{
  public:
    Sofa(int w = 0) : Mebel(w) {}
    void ogladajTV(){ cout << "Oglądaj telewizję" << endl; }
};
// RozkladanaSofa - jest zarówno klasy Lozko, jak i klasy Sofa
class RozkladanaSofa : public Lozko, public Sofa
{
  public:
    RozkladanaSofa(int w) : Mebel(w) {}
    void rozloz(){ cout << "Rozłóż" << endl; }
};
int main(int nLiczbaArgumentow, char* pszArgs[])
{
    RozkladanaSofa ss(10);
    // poniższy kod nie jest już wieloznaczny;
    // jest tylko jedna składowa waga współdzielona przez klasy Sofa i Lozko
    // czy to Mebel::Sofa czy Mebel::Lozko?
    cout << "Waga = " << ss.waga << endl;
    // aby pozwolić użytkownikowi zobaczyć wynik programu
    // przed zakończeniem programu, poczekaj, aż użytkownik będzie gotowy
    cout << "Naciśnij Enter, aby kontynuować..." << endl;
    cin.ignore(10, '\n');
    cin.get();
    return 0;
}
